/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Traffic Mirror session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficMirrorSession implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficMirrorSession.Builder, TrafficMirrorSession> {
    private static final SdkField<String> TRAFFIC_MIRROR_SESSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorSession::trafficMirrorSessionId))
            .setter(setter(Builder::trafficMirrorSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorSessionId")
                    .unmarshallLocationName("trafficMirrorSessionId").build()).build();

    private static final SdkField<String> TRAFFIC_MIRROR_TARGET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorSession::trafficMirrorTargetId))
            .setter(setter(Builder::trafficMirrorTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorTargetId")
                    .unmarshallLocationName("trafficMirrorTargetId").build()).build();

    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorSession::trafficMirrorFilterId))
            .setter(setter(Builder::trafficMirrorFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId")
                    .unmarshallLocationName("trafficMirrorFilterId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorSession::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorSession::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<Integer> PACKET_LENGTH_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TrafficMirrorSession::packetLength))
            .setter(setter(Builder::packetLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketLength")
                    .unmarshallLocationName("packetLength").build()).build();

    private static final SdkField<Integer> SESSION_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TrafficMirrorSession::sessionNumber))
            .setter(setter(Builder::sessionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionNumber")
                    .unmarshallLocationName("sessionNumber").build()).build();

    private static final SdkField<Integer> VIRTUAL_NETWORK_ID_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TrafficMirrorSession::virtualNetworkId))
            .setter(setter(Builder::virtualNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualNetworkId")
                    .unmarshallLocationName("virtualNetworkId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorSession::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(TrafficMirrorSession::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_MIRROR_SESSION_ID_FIELD, TRAFFIC_MIRROR_TARGET_ID_FIELD, TRAFFIC_MIRROR_FILTER_ID_FIELD,
            NETWORK_INTERFACE_ID_FIELD, OWNER_ID_FIELD, PACKET_LENGTH_FIELD, SESSION_NUMBER_FIELD, VIRTUAL_NETWORK_ID_FIELD,
            DESCRIPTION_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trafficMirrorSessionId;

    private final String trafficMirrorTargetId;

    private final String trafficMirrorFilterId;

    private final String networkInterfaceId;

    private final String ownerId;

    private final Integer packetLength;

    private final Integer sessionNumber;

    private final Integer virtualNetworkId;

    private final String description;

    private final List<Tag> tags;

    private TrafficMirrorSession(BuilderImpl builder) {
        this.trafficMirrorSessionId = builder.trafficMirrorSessionId;
        this.trafficMirrorTargetId = builder.trafficMirrorTargetId;
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.ownerId = builder.ownerId;
        this.packetLength = builder.packetLength;
        this.sessionNumber = builder.sessionNumber;
        this.virtualNetworkId = builder.virtualNetworkId;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID for the Traffic Mirror session.
     * </p>
     * 
     * @return The ID for the Traffic Mirror session.
     */
    public String trafficMirrorSessionId() {
        return trafficMirrorSessionId;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror target.
     * </p>
     * 
     * @return The ID of the Traffic Mirror target.
     */
    public String trafficMirrorTargetId() {
        return trafficMirrorTargetId;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror filter.
     * </p>
     * 
     * @return The ID of the Traffic Mirror filter.
     */
    public String trafficMirrorFilterId() {
        return trafficMirrorFilterId;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror session's network interface.
     * </p>
     * 
     * @return The ID of the Traffic Mirror session's network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The ID of the account that owns the Traffic Mirror session.
     * </p>
     * 
     * @return The ID of the account that owns the Traffic Mirror session.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The number of bytes in each packet to mirror. These are the bytes after the VXLAN header. To mirror a subset, set
     * this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that
     * meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the
     * entire packet
     * </p>
     * 
     * @return The number of bytes in each packet to mirror. These are the bytes after the VXLAN header. To mirror a
     *         subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the
     *         first 100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter
     *         when you want to mirror the entire packet
     */
    public Integer packetLength() {
        return packetLength;
    }

    /**
     * <p>
     * The session number determines the order in which sessions are evaluated when an interface is used by multiple
     * sessions. The first session with a matching filter is the one that mirrors the packets.
     * </p>
     * <p>
     * Valid values are 1-32766.
     * </p>
     * 
     * @return The session number determines the order in which sessions are evaluated when an interface is used by
     *         multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p>
     *         <p>
     *         Valid values are 1-32766.
     */
    public Integer sessionNumber() {
        return sessionNumber;
    }

    /**
     * <p>
     * The virtual network ID associated with the Traffic Mirror session.
     * </p>
     * 
     * @return The virtual network ID associated with the Traffic Mirror session.
     */
    public Integer virtualNetworkId() {
        return virtualNetworkId;
    }

    /**
     * <p>
     * The description of the Traffic Mirror session.
     * </p>
     * 
     * @return The description of the Traffic Mirror session.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the Traffic Mirror session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags assigned to the Traffic Mirror session.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(packetLength());
        hashCode = 31 * hashCode + Objects.hashCode(sessionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(virtualNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficMirrorSession)) {
            return false;
        }
        TrafficMirrorSession other = (TrafficMirrorSession) obj;
        return Objects.equals(trafficMirrorSessionId(), other.trafficMirrorSessionId())
                && Objects.equals(trafficMirrorTargetId(), other.trafficMirrorTargetId())
                && Objects.equals(trafficMirrorFilterId(), other.trafficMirrorFilterId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(packetLength(), other.packetLength()) && Objects.equals(sessionNumber(), other.sessionNumber())
                && Objects.equals(virtualNetworkId(), other.virtualNetworkId())
                && Objects.equals(description(), other.description()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TrafficMirrorSession").add("TrafficMirrorSessionId", trafficMirrorSessionId())
                .add("TrafficMirrorTargetId", trafficMirrorTargetId()).add("TrafficMirrorFilterId", trafficMirrorFilterId())
                .add("NetworkInterfaceId", networkInterfaceId()).add("OwnerId", ownerId()).add("PacketLength", packetLength())
                .add("SessionNumber", sessionNumber()).add("VirtualNetworkId", virtualNetworkId())
                .add("Description", description()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorSessionId":
            return Optional.ofNullable(clazz.cast(trafficMirrorSessionId()));
        case "TrafficMirrorTargetId":
            return Optional.ofNullable(clazz.cast(trafficMirrorTargetId()));
        case "TrafficMirrorFilterId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterId()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "PacketLength":
            return Optional.ofNullable(clazz.cast(packetLength()));
        case "SessionNumber":
            return Optional.ofNullable(clazz.cast(sessionNumber()));
        case "VirtualNetworkId":
            return Optional.ofNullable(clazz.cast(virtualNetworkId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficMirrorSession, T> g) {
        return obj -> g.apply((TrafficMirrorSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficMirrorSession> {
        /**
         * <p>
         * The ID for the Traffic Mirror session.
         * </p>
         * 
         * @param trafficMirrorSessionId
         *        The ID for the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorSessionId(String trafficMirrorSessionId);

        /**
         * <p>
         * The ID of the Traffic Mirror target.
         * </p>
         * 
         * @param trafficMirrorTargetId
         *        The ID of the Traffic Mirror target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorTargetId(String trafficMirrorTargetId);

        /**
         * <p>
         * The ID of the Traffic Mirror filter.
         * </p>
         * 
         * @param trafficMirrorFilterId
         *        The ID of the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterId(String trafficMirrorFilterId);

        /**
         * <p>
         * The ID of the Traffic Mirror session's network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the Traffic Mirror session's network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The ID of the account that owns the Traffic Mirror session.
         * </p>
         * 
         * @param ownerId
         *        The ID of the account that owns the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The number of bytes in each packet to mirror. These are the bytes after the VXLAN header. To mirror a subset,
         * set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100
         * bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you want to
         * mirror the entire packet
         * </p>
         * 
         * @param packetLength
         *        The number of bytes in each packet to mirror. These are the bytes after the VXLAN header. To mirror a
         *        subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then
         *        the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this
         *        parameter when you want to mirror the entire packet
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packetLength(Integer packetLength);

        /**
         * <p>
         * The session number determines the order in which sessions are evaluated when an interface is used by multiple
         * sessions. The first session with a matching filter is the one that mirrors the packets.
         * </p>
         * <p>
         * Valid values are 1-32766.
         * </p>
         * 
         * @param sessionNumber
         *        The session number determines the order in which sessions are evaluated when an interface is used by
         *        multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p>
         *        <p>
         *        Valid values are 1-32766.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionNumber(Integer sessionNumber);

        /**
         * <p>
         * The virtual network ID associated with the Traffic Mirror session.
         * </p>
         * 
         * @param virtualNetworkId
         *        The virtual network ID associated with the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNetworkId(Integer virtualNetworkId);

        /**
         * <p>
         * The description of the Traffic Mirror session.
         * </p>
         * 
         * @param description
         *        The description of the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags assigned to the Traffic Mirror session.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the Traffic Mirror session.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the Traffic Mirror session.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String trafficMirrorSessionId;

        private String trafficMirrorTargetId;

        private String trafficMirrorFilterId;

        private String networkInterfaceId;

        private String ownerId;

        private Integer packetLength;

        private Integer sessionNumber;

        private Integer virtualNetworkId;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficMirrorSession model) {
            trafficMirrorSessionId(model.trafficMirrorSessionId);
            trafficMirrorTargetId(model.trafficMirrorTargetId);
            trafficMirrorFilterId(model.trafficMirrorFilterId);
            networkInterfaceId(model.networkInterfaceId);
            ownerId(model.ownerId);
            packetLength(model.packetLength);
            sessionNumber(model.sessionNumber);
            virtualNetworkId(model.virtualNetworkId);
            description(model.description);
            tags(model.tags);
        }

        public final String getTrafficMirrorSessionId() {
            return trafficMirrorSessionId;
        }

        @Override
        public final Builder trafficMirrorSessionId(String trafficMirrorSessionId) {
            this.trafficMirrorSessionId = trafficMirrorSessionId;
            return this;
        }

        public final void setTrafficMirrorSessionId(String trafficMirrorSessionId) {
            this.trafficMirrorSessionId = trafficMirrorSessionId;
        }

        public final String getTrafficMirrorTargetId() {
            return trafficMirrorTargetId;
        }

        @Override
        public final Builder trafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
            return this;
        }

        public final void setTrafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
        }

        public final String getTrafficMirrorFilterId() {
            return trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final Integer getPacketLength() {
            return packetLength;
        }

        @Override
        public final Builder packetLength(Integer packetLength) {
            this.packetLength = packetLength;
            return this;
        }

        public final void setPacketLength(Integer packetLength) {
            this.packetLength = packetLength;
        }

        public final Integer getSessionNumber() {
            return sessionNumber;
        }

        @Override
        public final Builder sessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
            return this;
        }

        public final void setSessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
        }

        public final Integer getVirtualNetworkId() {
            return virtualNetworkId;
        }

        @Override
        public final Builder virtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
            return this;
        }

        public final void setVirtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public TrafficMirrorSession build() {
            return new TrafficMirrorSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
