/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedInstancesOffering implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedInstancesOffering.Builder, ReservedInstancesOffering> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesOffering::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(ReservedInstancesOffering::duration))
            .setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration")
                    .unmarshallLocationName("duration").build()).build();

    private static final SdkField<Float> FIXED_PRICE_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .getter(getter(ReservedInstancesOffering::fixedPrice))
            .setter(setter(Builder::fixedPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice")
                    .unmarshallLocationName("fixedPrice").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesOffering::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesOffering::productDescriptionAsString))
            .setter(setter(Builder::productDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription")
                    .unmarshallLocationName("productDescription").build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesOffering::reservedInstancesOfferingId))
            .setter(setter(Builder::reservedInstancesOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesOfferingId")
                    .unmarshallLocationName("reservedInstancesOfferingId").build()).build();

    private static final SdkField<Float> USAGE_PRICE_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .getter(getter(ReservedInstancesOffering::usagePrice))
            .setter(setter(Builder::usagePrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice")
                    .unmarshallLocationName("usagePrice").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesOffering::currencyCodeAsString))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("currencyCode").build()).build();

    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesOffering::instanceTenancyAsString))
            .setter(setter(Builder::instanceTenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy")
                    .unmarshallLocationName("instanceTenancy").build()).build();

    private static final SdkField<Boolean> MARKETPLACE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ReservedInstancesOffering::marketplace))
            .setter(setter(Builder::marketplace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketplace")
                    .unmarshallLocationName("marketplace").build()).build();

    private static final SdkField<String> OFFERING_CLASS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesOffering::offeringClassAsString))
            .setter(setter(Builder::offeringClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingClass")
                    .unmarshallLocationName("offeringClass").build()).build();

    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesOffering::offeringTypeAsString))
            .setter(setter(Builder::offeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType")
                    .unmarshallLocationName("offeringType").build()).build();

    private static final SdkField<List<PricingDetail>> PRICING_DETAILS_FIELD = SdkField
            .<List<PricingDetail>> builder(MarshallingType.LIST)
            .getter(getter(ReservedInstancesOffering::pricingDetails))
            .setter(setter(Builder::pricingDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingDetailsSet")
                    .unmarshallLocationName("pricingDetailsSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PricingDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(PricingDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField
            .<List<RecurringCharge>> builder(MarshallingType.LIST)
            .getter(getter(ReservedInstancesOffering::recurringCharges))
            .setter(setter(Builder::recurringCharges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges")
                    .unmarshallLocationName("recurringCharges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RecurringCharge> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecurringCharge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesOffering::scopeAsString))
            .setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope")
                    .unmarshallLocationName("scope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            DURATION_FIELD, FIXED_PRICE_FIELD, INSTANCE_TYPE_FIELD, PRODUCT_DESCRIPTION_FIELD,
            RESERVED_INSTANCES_OFFERING_ID_FIELD, USAGE_PRICE_FIELD, CURRENCY_CODE_FIELD, INSTANCE_TENANCY_FIELD,
            MARKETPLACE_FIELD, OFFERING_CLASS_FIELD, OFFERING_TYPE_FIELD, PRICING_DETAILS_FIELD, RECURRING_CHARGES_FIELD,
            SCOPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final Long duration;

    private final Float fixedPrice;

    private final String instanceType;

    private final String productDescription;

    private final String reservedInstancesOfferingId;

    private final Float usagePrice;

    private final String currencyCode;

    private final String instanceTenancy;

    private final Boolean marketplace;

    private final String offeringClass;

    private final String offeringType;

    private final List<PricingDetail> pricingDetails;

    private final List<RecurringCharge> recurringCharges;

    private final String scope;

    private ReservedInstancesOffering(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.instanceType = builder.instanceType;
        this.productDescription = builder.productDescription;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.marketplace = builder.marketplace;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.pricingDetails = builder.pricingDetails;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
    }

    /**
     * <p>
     * The Availability Zone in which the Reserved Instance can be used.
     * </p>
     * 
     * @return The Availability Zone in which the Reserved Instance can be used.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The duration of the Reserved Instance, in seconds.
     * </p>
     * 
     * @return The duration of the Reserved Instance, in seconds.
     */
    public Long duration() {
        return duration;
    }

    /**
     * <p>
     * The purchase price of the Reserved Instance.
     * </p>
     * 
     * @return The purchase price of the Reserved Instance.
     */
    public Float fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The instance type on which the Reserved Instance can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type on which the Reserved Instance can be used.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type on which the Reserved Instance can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type on which the Reserved Instance can be used.
     * @see InstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The Reserved Instance product platform description.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionAsString}.
     * </p>
     * 
     * @return The Reserved Instance product platform description.
     * @see RIProductDescription
     */
    public RIProductDescription productDescription() {
        return RIProductDescription.fromValue(productDescription);
    }

    /**
     * <p>
     * The Reserved Instance product platform description.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionAsString}.
     * </p>
     * 
     * @return The Reserved Instance product platform description.
     * @see RIProductDescription
     */
    public String productDescriptionAsString() {
        return productDescription;
    }

    /**
     * <p>
     * The ID of the Reserved Instance offering. This is the offering ID used in
     * <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
     * </p>
     * 
     * @return The ID of the Reserved Instance offering. This is the offering ID used in
     *         <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
     */
    public String reservedInstancesOfferingId() {
        return reservedInstancesOfferingId;
    }

    /**
     * <p>
     * The usage price of the Reserved Instance, per hour.
     * </p>
     * 
     * @return The usage price of the Reserved Instance, per hour.
     */
    public Float usagePrice() {
        return usagePrice;
    }

    /**
     * <p>
     * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     * currency codes. At this time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     *         currency codes. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     * currency codes. At this time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     *         currency codes. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * <p>
     * The tenancy of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the instance.
     * @see Tenancy
     */
    public Tenancy instanceTenancy() {
        return Tenancy.fromValue(instanceTenancy);
    }

    /**
     * <p>
     * The tenancy of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The tenancy of the instance.
     * @see Tenancy
     */
    public String instanceTenancyAsString() {
        return instanceTenancy;
    }

    /**
     * <p>
     * Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS. If it's a
     * Reserved Instance Marketplace offering, this is <code>true</code>.
     * </p>
     * 
     * @return Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS. If
     *         it's a Reserved Instance Marketplace offering, this is <code>true</code>.
     */
    public Boolean marketplace() {
        return marketplace;
    }

    /**
     * <p>
     * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value, with
     * different configurations. If <code>standard</code>, it is not possible to perform an exchange.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassAsString}.
     * </p>
     * 
     * @return If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
     *         value, with different configurations. If <code>standard</code>, it is not possible to perform an
     *         exchange.
     * @see OfferingClassType
     */
    public OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(offeringClass);
    }

    /**
     * <p>
     * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value, with
     * different configurations. If <code>standard</code>, it is not possible to perform an exchange.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassAsString}.
     * </p>
     * 
     * @return If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
     *         value, with different configurations. If <code>standard</code>, it is not possible to perform an
     *         exchange.
     * @see OfferingClassType
     */
    public String offeringClassAsString() {
        return offeringClass;
    }

    /**
     * <p>
     * The Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeAsString}.
     * </p>
     * 
     * @return The Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(offeringType);
    }

    /**
     * <p>
     * The Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeAsString}.
     * </p>
     * 
     * @return The Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public String offeringTypeAsString() {
        return offeringType;
    }

    /**
     * Returns true if the PricingDetails property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPricingDetails() {
        return pricingDetails != null && !(pricingDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The pricing details of the Reserved Instance offering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPricingDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The pricing details of the Reserved Instance offering.
     */
    public List<PricingDetail> pricingDetails() {
        return pricingDetails;
    }

    /**
     * Returns true if the RecurringCharges property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRecurringCharges() {
        return recurringCharges != null && !(recurringCharges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recurring charge tag assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecurringCharges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The recurring charge tag assigned to the resource.
     */
    public List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    /**
     * <p>
     * Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
     * @see Scope
     */
    public Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
     * @see Scope
     */
    public String scopeAsString() {
        return scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(productDescriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(marketplace());
        hashCode = 31 * hashCode + Objects.hashCode(offeringClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pricingDetails());
        hashCode = 31 * hashCode + Objects.hashCode(recurringCharges());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesOffering)) {
            return false;
        }
        ReservedInstancesOffering other = (ReservedInstancesOffering) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(duration(), other.duration())
                && Objects.equals(fixedPrice(), other.fixedPrice())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(productDescriptionAsString(), other.productDescriptionAsString())
                && Objects.equals(reservedInstancesOfferingId(), other.reservedInstancesOfferingId())
                && Objects.equals(usagePrice(), other.usagePrice())
                && Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(instanceTenancyAsString(), other.instanceTenancyAsString())
                && Objects.equals(marketplace(), other.marketplace())
                && Objects.equals(offeringClassAsString(), other.offeringClassAsString())
                && Objects.equals(offeringTypeAsString(), other.offeringTypeAsString())
                && Objects.equals(pricingDetails(), other.pricingDetails())
                && Objects.equals(recurringCharges(), other.recurringCharges())
                && Objects.equals(scopeAsString(), other.scopeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReservedInstancesOffering").add("AvailabilityZone", availabilityZone())
                .add("Duration", duration()).add("FixedPrice", fixedPrice()).add("InstanceType", instanceTypeAsString())
                .add("ProductDescription", productDescriptionAsString())
                .add("ReservedInstancesOfferingId", reservedInstancesOfferingId()).add("UsagePrice", usagePrice())
                .add("CurrencyCode", currencyCodeAsString()).add("InstanceTenancy", instanceTenancyAsString())
                .add("Marketplace", marketplace()).add("OfferingClass", offeringClassAsString())
                .add("OfferingType", offeringTypeAsString()).add("PricingDetails", pricingDetails())
                .add("RecurringCharges", recurringCharges()).add("Scope", scopeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "FixedPrice":
            return Optional.ofNullable(clazz.cast(fixedPrice()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "ProductDescription":
            return Optional.ofNullable(clazz.cast(productDescriptionAsString()));
        case "ReservedInstancesOfferingId":
            return Optional.ofNullable(clazz.cast(reservedInstancesOfferingId()));
        case "UsagePrice":
            return Optional.ofNullable(clazz.cast(usagePrice()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        case "InstanceTenancy":
            return Optional.ofNullable(clazz.cast(instanceTenancyAsString()));
        case "Marketplace":
            return Optional.ofNullable(clazz.cast(marketplace()));
        case "OfferingClass":
            return Optional.ofNullable(clazz.cast(offeringClassAsString()));
        case "OfferingType":
            return Optional.ofNullable(clazz.cast(offeringTypeAsString()));
        case "PricingDetails":
            return Optional.ofNullable(clazz.cast(pricingDetails()));
        case "RecurringCharges":
            return Optional.ofNullable(clazz.cast(recurringCharges()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesOffering, T> g) {
        return obj -> g.apply((ReservedInstancesOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedInstancesOffering> {
        /**
         * <p>
         * The Availability Zone in which the Reserved Instance can be used.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the Reserved Instance can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The duration of the Reserved Instance, in seconds.
         * </p>
         * 
         * @param duration
         *        The duration of the Reserved Instance, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * The purchase price of the Reserved Instance.
         * </p>
         * 
         * @param fixedPrice
         *        The purchase price of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Float fixedPrice);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(RIProductDescription productDescription);

        /**
         * <p>
         * The ID of the Reserved Instance offering. This is the offering ID used in
         * <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
         * </p>
         * 
         * @param reservedInstancesOfferingId
         *        The ID of the Reserved Instance offering. This is the offering ID used in
         *        <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferingId(String reservedInstancesOfferingId);

        /**
         * <p>
         * The usage price of the Reserved Instance, per hour.
         * </p>
         * 
         * @param usagePrice
         *        The usage price of the Reserved Instance, per hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Float usagePrice);

        /**
         * <p>
         * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
         * currency codes. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217
         *        standard currency codes. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
         * currency codes. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217
         *        standard currency codes. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);

        /**
         * <p>
         * Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS. If
         * it's a Reserved Instance Marketplace offering, this is <code>true</code>.
         * </p>
         * 
         * @param marketplace
         *        Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS.
         *        If it's a Reserved Instance Marketplace offering, this is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketplace(Boolean marketplace);

        /**
         * <p>
         * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value,
         * with different configurations. If <code>standard</code>, it is not possible to perform an exchange.
         * </p>
         * 
         * @param offeringClass
         *        If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
         *        value, with different configurations. If <code>standard</code>, it is not possible to perform an
         *        exchange.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(String offeringClass);

        /**
         * <p>
         * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value,
         * with different configurations. If <code>standard</code>, it is not possible to perform an exchange.
         * </p>
         * 
         * @param offeringClass
         *        If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
         *        value, with different configurations. If <code>standard</code>, it is not possible to perform an
         *        exchange.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(OfferingClassType offeringClass);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(OfferingTypeValues offeringType);

        /**
         * <p>
         * The pricing details of the Reserved Instance offering.
         * </p>
         * 
         * @param pricingDetails
         *        The pricing details of the Reserved Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingDetails(Collection<PricingDetail> pricingDetails);

        /**
         * <p>
         * The pricing details of the Reserved Instance offering.
         * </p>
         * 
         * @param pricingDetails
         *        The pricing details of the Reserved Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingDetails(PricingDetail... pricingDetails);

        /**
         * <p>
         * The pricing details of the Reserved Instance offering.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PricingDetail>.Builder} avoiding the need
         * to create one manually via {@link List<PricingDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PricingDetail>.Builder#build()} is called immediately and
         * its result is passed to {@link #pricingDetails(List<PricingDetail>)}.
         * 
         * @param pricingDetails
         *        a consumer that will call methods on {@link List<PricingDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pricingDetails(List<PricingDetail>)
         */
        Builder pricingDetails(Consumer<PricingDetail.Builder>... pricingDetails);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecurringCharge>.Builder} avoiding the need
         * to create one manually via {@link List<RecurringCharge>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecurringCharge>.Builder#build()} is called immediately and
         * its result is passed to {@link #recurringCharges(List<RecurringCharge>)}.
         * 
         * @param recurringCharges
         *        a consumer that will call methods on {@link List<RecurringCharge>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurringCharges(List<RecurringCharge>)
         */
        Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges);

        /**
         * <p>
         * Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
         * </p>
         * 
         * @param scope
         *        Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
         * </p>
         * 
         * @param scope
         *        Whether the Reserved Instance is applied to instances in a Region or an Availability Zone.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Long duration;

        private Float fixedPrice;

        private String instanceType;

        private String productDescription;

        private String reservedInstancesOfferingId;

        private Float usagePrice;

        private String currencyCode;

        private String instanceTenancy;

        private Boolean marketplace;

        private String offeringClass;

        private String offeringType;

        private List<PricingDetail> pricingDetails = DefaultSdkAutoConstructList.getInstance();

        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesOffering model) {
            availabilityZone(model.availabilityZone);
            duration(model.duration);
            fixedPrice(model.fixedPrice);
            instanceType(model.instanceType);
            productDescription(model.productDescription);
            reservedInstancesOfferingId(model.reservedInstancesOfferingId);
            usagePrice(model.usagePrice);
            currencyCode(model.currencyCode);
            instanceTenancy(model.instanceTenancy);
            marketplace(model.marketplace);
            offeringClass(model.offeringClass);
            offeringType(model.offeringType);
            pricingDetails(model.pricingDetails);
            recurringCharges(model.recurringCharges);
            scope(model.scope);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final Float getFixedPrice() {
            return fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final String getInstanceTypeAsString() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getProductDescriptionAsString() {
            return productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription == null ? null : productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getReservedInstancesOfferingId() {
            return reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        public final Float getUsagePrice() {
            return usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCodeAsString() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final String getInstanceTenancyAsString() {
            return instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy == null ? null : instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final Boolean getMarketplace() {
            return marketplace;
        }

        @Override
        public final Builder marketplace(Boolean marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        public final void setMarketplace(Boolean marketplace) {
            this.marketplace = marketplace;
        }

        public final String getOfferingClassAsString() {
            return offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass == null ? null : offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final String getOfferingTypeAsString() {
            return offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType == null ? null : offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Collection<PricingDetail.Builder> getPricingDetails() {
            return pricingDetails != null ? pricingDetails.stream().map(PricingDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder pricingDetails(Collection<PricingDetail> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copy(pricingDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingDetails(PricingDetail... pricingDetails) {
            pricingDetails(Arrays.asList(pricingDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingDetails(Consumer<PricingDetail.Builder>... pricingDetails) {
            pricingDetails(Stream.of(pricingDetails).map(c -> PricingDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPricingDetails(Collection<PricingDetail.BuilderImpl> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copyFromBuilder(pricingDetails);
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            return recurringCharges != null ? recurringCharges.stream().map(RecurringCharge::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges) {
            recurringCharges(Stream.of(recurringCharges).map(c -> RecurringCharge.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copyFromBuilder(recurringCharges);
        }

        public final String getScopeAsString() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public ReservedInstancesOffering build() {
            return new ReservedInstancesOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
