/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an export image task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportImageTask implements SdkPojo, Serializable, ToCopyableBuilder<ExportImageTask.Builder, ExportImageTask> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportImageTask::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> EXPORT_IMAGE_TASK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportImageTask::exportImageTaskId))
            .setter(setter(Builder::exportImageTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportImageTaskId")
                    .unmarshallLocationName("exportImageTaskId").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportImageTask::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> PROGRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportImageTask::progress))
            .setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress")
                    .unmarshallLocationName("progress").build()).build();

    private static final SdkField<ExportTaskS3Location> S3_EXPORT_LOCATION_FIELD = SdkField
            .<ExportTaskS3Location> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExportImageTask::s3ExportLocation))
            .setter(setter(Builder::s3ExportLocation))
            .constructor(ExportTaskS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ExportLocation")
                    .unmarshallLocationName("s3ExportLocation").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportImageTask::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportImageTask::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            EXPORT_IMAGE_TASK_ID_FIELD, IMAGE_ID_FIELD, PROGRESS_FIELD, S3_EXPORT_LOCATION_FIELD, STATUS_FIELD,
            STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String exportImageTaskId;

    private final String imageId;

    private final String progress;

    private final ExportTaskS3Location s3ExportLocation;

    private final String status;

    private final String statusMessage;

    private ExportImageTask(BuilderImpl builder) {
        this.description = builder.description;
        this.exportImageTaskId = builder.exportImageTaskId;
        this.imageId = builder.imageId;
        this.progress = builder.progress;
        this.s3ExportLocation = builder.s3ExportLocation;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * A description of the image being exported.
     * </p>
     * 
     * @return A description of the image being exported.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the export image task.
     * </p>
     * 
     * @return The ID of the export image task.
     */
    public String exportImageTaskId() {
        return exportImageTaskId;
    }

    /**
     * <p>
     * The ID of the image.
     * </p>
     * 
     * @return The ID of the image.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The percent complete of the export image task.
     * </p>
     * 
     * @return The percent complete of the export image task.
     */
    public String progress() {
        return progress;
    }

    /**
     * <p>
     * Information about the destination S3 bucket.
     * </p>
     * 
     * @return Information about the destination S3 bucket.
     */
    public ExportTaskS3Location s3ExportLocation() {
        return s3ExportLocation;
    }

    /**
     * <p>
     * The status of the export image task. The possible values are <code>active</code>, <code>completed</code>,
     * <code>deleting</code>, and <code>deleted</code>.
     * </p>
     * 
     * @return The status of the export image task. The possible values are <code>active</code>, <code>completed</code>,
     *         <code>deleting</code>, and <code>deleted</code>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The status message for the export image task.
     * </p>
     * 
     * @return The status message for the export image task.
     */
    public String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(exportImageTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(s3ExportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportImageTask)) {
            return false;
        }
        ExportImageTask other = (ExportImageTask) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(exportImageTaskId(), other.exportImageTaskId()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(progress(), other.progress()) && Objects.equals(s3ExportLocation(), other.s3ExportLocation())
                && Objects.equals(status(), other.status()) && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportImageTask").add("Description", description())
                .add("ExportImageTaskId", exportImageTaskId()).add("ImageId", imageId()).add("Progress", progress())
                .add("S3ExportLocation", s3ExportLocation()).add("Status", status()).add("StatusMessage", statusMessage())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ExportImageTaskId":
            return Optional.ofNullable(clazz.cast(exportImageTaskId()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "S3ExportLocation":
            return Optional.ofNullable(clazz.cast(s3ExportLocation()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportImageTask, T> g) {
        return obj -> g.apply((ExportImageTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportImageTask> {
        /**
         * <p>
         * A description of the image being exported.
         * </p>
         * 
         * @param description
         *        A description of the image being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the export image task.
         * </p>
         * 
         * @param exportImageTaskId
         *        The ID of the export image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportImageTaskId(String exportImageTaskId);

        /**
         * <p>
         * The ID of the image.
         * </p>
         * 
         * @param imageId
         *        The ID of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The percent complete of the export image task.
         * </p>
         * 
         * @param progress
         *        The percent complete of the export image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * Information about the destination S3 bucket.
         * </p>
         * 
         * @param s3ExportLocation
         *        Information about the destination S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ExportLocation(ExportTaskS3Location s3ExportLocation);

        /**
         * <p>
         * Information about the destination S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportTaskS3Location.Builder} avoiding the need
         * to create one manually via {@link ExportTaskS3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportTaskS3Location.Builder#build()} is called immediately and
         * its result is passed to {@link #s3ExportLocation(ExportTaskS3Location)}.
         * 
         * @param s3ExportLocation
         *        a consumer that will call methods on {@link ExportTaskS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ExportLocation(ExportTaskS3Location)
         */
        default Builder s3ExportLocation(Consumer<ExportTaskS3Location.Builder> s3ExportLocation) {
            return s3ExportLocation(ExportTaskS3Location.builder().applyMutation(s3ExportLocation).build());
        }

        /**
         * <p>
         * The status of the export image task. The possible values are <code>active</code>, <code>completed</code>,
         * <code>deleting</code>, and <code>deleted</code>.
         * </p>
         * 
         * @param status
         *        The status of the export image task. The possible values are <code>active</code>,
         *        <code>completed</code>, <code>deleting</code>, and <code>deleted</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The status message for the export image task.
         * </p>
         * 
         * @param statusMessage
         *        The status message for the export image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String exportImageTaskId;

        private String imageId;

        private String progress;

        private ExportTaskS3Location s3ExportLocation;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportImageTask model) {
            description(model.description);
            exportImageTaskId(model.exportImageTaskId);
            imageId(model.imageId);
            progress(model.progress);
            s3ExportLocation(model.s3ExportLocation);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getExportImageTaskId() {
            return exportImageTaskId;
        }

        @Override
        public final Builder exportImageTaskId(String exportImageTaskId) {
            this.exportImageTaskId = exportImageTaskId;
            return this;
        }

        public final void setExportImageTaskId(String exportImageTaskId) {
            this.exportImageTaskId = exportImageTaskId;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final ExportTaskS3Location.Builder getS3ExportLocation() {
            return s3ExportLocation != null ? s3ExportLocation.toBuilder() : null;
        }

        @Override
        public final Builder s3ExportLocation(ExportTaskS3Location s3ExportLocation) {
            this.s3ExportLocation = s3ExportLocation;
            return this;
        }

        public final void setS3ExportLocation(ExportTaskS3Location.BuilderImpl s3ExportLocation) {
            this.s3ExportLocation = s3ExportLocation != null ? s3ExportLocation.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public ExportImageTask build() {
            return new ExportImageTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
