/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClientVpnAuthorizationRulesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeClientVpnAuthorizationRulesResponse.Builder, DescribeClientVpnAuthorizationRulesResponse> {
    private static final SdkField<List<AuthorizationRule>> AUTHORIZATION_RULES_FIELD = SdkField
            .<List<AuthorizationRule>> builder(MarshallingType.LIST)
            .getter(getter(DescribeClientVpnAuthorizationRulesResponse::authorizationRules))
            .setter(setter(Builder::authorizationRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationRule")
                    .unmarshallLocationName("authorizationRule").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AuthorizationRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthorizationRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClientVpnAuthorizationRulesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_RULES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AuthorizationRule> authorizationRules;

    private final String nextToken;

    private DescribeClientVpnAuthorizationRulesResponse(BuilderImpl builder) {
        super(builder);
        this.authorizationRules = builder.authorizationRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AuthorizationRules property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAuthorizationRules() {
        return authorizationRules != null && !(authorizationRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the authorization rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAuthorizationRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the authorization rules.
     */
    public List<AuthorizationRule> authorizationRules() {
        return authorizationRules;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorizationRules());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientVpnAuthorizationRulesResponse)) {
            return false;
        }
        DescribeClientVpnAuthorizationRulesResponse other = (DescribeClientVpnAuthorizationRulesResponse) obj;
        return Objects.equals(authorizationRules(), other.authorizationRules()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeClientVpnAuthorizationRulesResponse").add("AuthorizationRules", authorizationRules())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizationRules":
            return Optional.ofNullable(clazz.cast(authorizationRules()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientVpnAuthorizationRulesResponse, T> g) {
        return obj -> g.apply((DescribeClientVpnAuthorizationRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClientVpnAuthorizationRulesResponse> {
        /**
         * <p>
         * Information about the authorization rules.
         * </p>
         * 
         * @param authorizationRules
         *        Information about the authorization rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationRules(Collection<AuthorizationRule> authorizationRules);

        /**
         * <p>
         * Information about the authorization rules.
         * </p>
         * 
         * @param authorizationRules
         *        Information about the authorization rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationRules(AuthorizationRule... authorizationRules);

        /**
         * <p>
         * Information about the authorization rules.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AuthorizationRule>.Builder} avoiding the
         * need to create one manually via {@link List<AuthorizationRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AuthorizationRule>.Builder#build()} is called immediately
         * and its result is passed to {@link #authorizationRules(List<AuthorizationRule>)}.
         * 
         * @param authorizationRules
         *        a consumer that will call methods on {@link List<AuthorizationRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizationRules(List<AuthorizationRule>)
         */
        Builder authorizationRules(Consumer<AuthorizationRule.Builder>... authorizationRules);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<AuthorizationRule> authorizationRules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientVpnAuthorizationRulesResponse model) {
            super(model);
            authorizationRules(model.authorizationRules);
            nextToken(model.nextToken);
        }

        public final Collection<AuthorizationRule.Builder> getAuthorizationRules() {
            return authorizationRules != null ? authorizationRules.stream().map(AuthorizationRule::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder authorizationRules(Collection<AuthorizationRule> authorizationRules) {
            this.authorizationRules = AuthorizationRuleSetCopier.copy(authorizationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationRules(AuthorizationRule... authorizationRules) {
            authorizationRules(Arrays.asList(authorizationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationRules(Consumer<AuthorizationRule.Builder>... authorizationRules) {
            authorizationRules(Stream.of(authorizationRules).map(c -> AuthorizationRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAuthorizationRules(Collection<AuthorizationRule.BuilderImpl> authorizationRules) {
            this.authorizationRules = AuthorizationRuleSetCopier.copyFromBuilder(authorizationRules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeClientVpnAuthorizationRulesResponse build() {
            return new DescribeClientVpnAuthorizationRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
