/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateSpotDatafeedSubscription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSpotDatafeedSubscriptionResponse extends Ec2Response implements
        ToCopyableBuilder<CreateSpotDatafeedSubscriptionResponse.Builder, CreateSpotDatafeedSubscriptionResponse> {
    private static final SdkField<SpotDatafeedSubscription> SPOT_DATAFEED_SUBSCRIPTION_FIELD = SdkField
            .<SpotDatafeedSubscription> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateSpotDatafeedSubscriptionResponse::spotDatafeedSubscription))
            .setter(setter(Builder::spotDatafeedSubscription))
            .constructor(SpotDatafeedSubscription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotDatafeedSubscription")
                    .unmarshallLocationName("spotDatafeedSubscription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SPOT_DATAFEED_SUBSCRIPTION_FIELD));

    private final SpotDatafeedSubscription spotDatafeedSubscription;

    private CreateSpotDatafeedSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.spotDatafeedSubscription = builder.spotDatafeedSubscription;
    }

    /**
     * <p>
     * The Spot Instance data feed subscription.
     * </p>
     * 
     * @return The Spot Instance data feed subscription.
     */
    public SpotDatafeedSubscription spotDatafeedSubscription() {
        return spotDatafeedSubscription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(spotDatafeedSubscription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSpotDatafeedSubscriptionResponse)) {
            return false;
        }
        CreateSpotDatafeedSubscriptionResponse other = (CreateSpotDatafeedSubscriptionResponse) obj;
        return Objects.equals(spotDatafeedSubscription(), other.spotDatafeedSubscription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSpotDatafeedSubscriptionResponse")
                .add("SpotDatafeedSubscription", spotDatafeedSubscription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotDatafeedSubscription":
            return Optional.ofNullable(clazz.cast(spotDatafeedSubscription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSpotDatafeedSubscriptionResponse, T> g) {
        return obj -> g.apply((CreateSpotDatafeedSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSpotDatafeedSubscriptionResponse> {
        /**
         * <p>
         * The Spot Instance data feed subscription.
         * </p>
         * 
         * @param spotDatafeedSubscription
         *        The Spot Instance data feed subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotDatafeedSubscription(SpotDatafeedSubscription spotDatafeedSubscription);

        /**
         * <p>
         * The Spot Instance data feed subscription.
         * </p>
         * This is a convenience that creates an instance of the {@link SpotDatafeedSubscription.Builder} avoiding the
         * need to create one manually via {@link SpotDatafeedSubscription#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpotDatafeedSubscription.Builder#build()} is called immediately
         * and its result is passed to {@link #spotDatafeedSubscription(SpotDatafeedSubscription)}.
         * 
         * @param spotDatafeedSubscription
         *        a consumer that will call methods on {@link SpotDatafeedSubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotDatafeedSubscription(SpotDatafeedSubscription)
         */
        default Builder spotDatafeedSubscription(Consumer<SpotDatafeedSubscription.Builder> spotDatafeedSubscription) {
            return spotDatafeedSubscription(SpotDatafeedSubscription.builder().applyMutation(spotDatafeedSubscription).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private SpotDatafeedSubscription spotDatafeedSubscription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSpotDatafeedSubscriptionResponse model) {
            super(model);
            spotDatafeedSubscription(model.spotDatafeedSubscription);
        }

        public final SpotDatafeedSubscription.Builder getSpotDatafeedSubscription() {
            return spotDatafeedSubscription != null ? spotDatafeedSubscription.toBuilder() : null;
        }

        @Override
        public final Builder spotDatafeedSubscription(SpotDatafeedSubscription spotDatafeedSubscription) {
            this.spotDatafeedSubscription = spotDatafeedSubscription;
            return this;
        }

        public final void setSpotDatafeedSubscription(SpotDatafeedSubscription.BuilderImpl spotDatafeedSubscription) {
            this.spotDatafeedSubscription = spotDatafeedSubscription != null ? spotDatafeedSubscription.build() : null;
        }

        @Override
        public CreateSpotDatafeedSubscriptionResponse build() {
            return new CreateSpotDatafeedSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
