/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockDeviceMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<BlockDeviceMapping.Builder, BlockDeviceMapping> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(BlockDeviceMapping::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName")
                    .unmarshallLocationName("deviceName").build()).build();

    private static final SdkField<String> VIRTUAL_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(BlockDeviceMapping::virtualName))
            .setter(setter(Builder::virtualName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualName")
                    .unmarshallLocationName("virtualName").build()).build();

    private static final SdkField<EbsBlockDevice> EBS_FIELD = SdkField
            .<EbsBlockDevice> builder(MarshallingType.SDK_POJO)
            .getter(getter(BlockDeviceMapping::ebs))
            .setter(setter(Builder::ebs))
            .constructor(EbsBlockDevice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ebs").unmarshallLocationName("ebs")
                    .build()).build();

    private static final SdkField<String> NO_DEVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(BlockDeviceMapping::noDevice))
            .setter(setter(Builder::noDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoDevice")
                    .unmarshallLocationName("noDevice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD,
            VIRTUAL_NAME_FIELD, EBS_FIELD, NO_DEVICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final String virtualName;

    private final EbsBlockDevice ebs;

    private final String noDevice;

    private BlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.virtualName = builder.virtualName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
    }

    /**
     * <p>
     * The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * 
     * @return The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An
     * instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and
     * <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. After you
     * connect to the instance, you must mount the volume.
     * </p>
     * <p>
     * NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in your block
     * device mapping has no effect.
     * </p>
     * <p>
     * Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the
     * instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device
     * mapping for the AMI.
     * </p>
     * 
     * @return The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0.
     *         An instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code>
     *         and <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type.
     *         After you connect to the instance, you must mount the volume.</p>
     *         <p>
     *         NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in
     *         your block device mapping has no effect.
     *         </p>
     *         <p>
     *         Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for
     *         the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block
     *         device mapping for the AMI.
     */
    public String virtualName() {
        return virtualName;
    }

    /**
     * <p>
     * Parameters used to automatically set up EBS volumes when the instance is launched.
     * </p>
     * 
     * @return Parameters used to automatically set up EBS volumes when the instance is launched.
     */
    public EbsBlockDevice ebs() {
        return ebs;
    }

    /**
     * <p>
     * Suppresses the specified device included in the block device mapping of the AMI.
     * </p>
     * 
     * @return Suppresses the specified device included in the block device mapping of the AMI.
     */
    public String noDevice() {
        return noDevice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(virtualName());
        hashCode = 31 * hashCode + Objects.hashCode(ebs());
        hashCode = 31 * hashCode + Objects.hashCode(noDevice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockDeviceMapping)) {
            return false;
        }
        BlockDeviceMapping other = (BlockDeviceMapping) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(virtualName(), other.virtualName())
                && Objects.equals(ebs(), other.ebs()) && Objects.equals(noDevice(), other.noDevice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BlockDeviceMapping").add("DeviceName", deviceName()).add("VirtualName", virtualName())
                .add("Ebs", ebs()).add("NoDevice", noDevice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "VirtualName":
            return Optional.ofNullable(clazz.cast(virtualName()));
        case "Ebs":
            return Optional.ofNullable(clazz.cast(ebs()));
        case "NoDevice":
            return Optional.ofNullable(clazz.cast(noDevice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlockDeviceMapping, T> g) {
        return obj -> g.apply((BlockDeviceMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockDeviceMapping> {
        /**
         * <p>
         * The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * 
         * @param deviceName
         *        The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An
         * instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and
         * <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. After
         * you connect to the instance, you must mount the volume.
         * </p>
         * <p>
         * NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in your
         * block device mapping has no effect.
         * </p>
         * <p>
         * Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the
         * instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device
         * mapping for the AMI.
         * </p>
         * 
         * @param virtualName
         *        The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from
         *        0. An instance type with 2 available instance store volumes can specify mappings for
         *        <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store volumes
         *        depends on the instance type. After you connect to the instance, you must mount the volume.</p>
         *        <p>
         *        NVMe instance store volumes are automatically enumerated and assigned a device name. Including them in
         *        your block device mapping has no effect.
         *        </p>
         *        <p>
         *        Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for
         *        the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the
         *        block device mapping for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);

        /**
         * <p>
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         * </p>
         * 
         * @param ebs
         *        Parameters used to automatically set up EBS volumes when the instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(EbsBlockDevice ebs);

        /**
         * <p>
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         * </p>
         * This is a convenience that creates an instance of the {@link EbsBlockDevice.Builder} avoiding the need to
         * create one manually via {@link EbsBlockDevice#builder()}.
         *
         * When the {@link Consumer} completes, {@link EbsBlockDevice.Builder#build()} is called immediately and its
         * result is passed to {@link #ebs(EbsBlockDevice)}.
         * 
         * @param ebs
         *        a consumer that will call methods on {@link EbsBlockDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebs(EbsBlockDevice)
         */
        default Builder ebs(Consumer<EbsBlockDevice.Builder> ebs) {
            return ebs(EbsBlockDevice.builder().applyMutation(ebs).build());
        }

        /**
         * <p>
         * Suppresses the specified device included in the block device mapping of the AMI.
         * </p>
         * 
         * @param noDevice
         *        Suppresses the specified device included in the block device mapping of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(String noDevice);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private String virtualName;

        private EbsBlockDevice ebs;

        private String noDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockDeviceMapping model) {
            deviceName(model.deviceName);
            virtualName(model.virtualName);
            ebs(model.ebs);
            noDevice(model.noDevice);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getVirtualName() {
            return virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public final EbsBlockDevice.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(EbsBlockDevice ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsBlockDevice.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        public final String getNoDevice() {
            return noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        @Override
        public BlockDeviceMapping build() {
            return new BlockDeviceMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
