/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the modification status of an EBS volume.
 * </p>
 * <p>
 * If the volume has never been modified, some element values will be null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeModification implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeModification.Builder, VolumeModification> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeModification::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("volumeId").build()).build();

    private static final SdkField<String> MODIFICATION_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeModification::modificationStateAsString))
            .setter(setter(Builder::modificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationState")
                    .unmarshallLocationName("modificationState").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeModification::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<Integer> TARGET_SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(VolumeModification::targetSize))
            .setter(setter(Builder::targetSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSize")
                    .unmarshallLocationName("targetSize").build()).build();

    private static final SdkField<Integer> TARGET_IOPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(VolumeModification::targetIops))
            .setter(setter(Builder::targetIops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIops")
                    .unmarshallLocationName("targetIops").build()).build();

    private static final SdkField<String> TARGET_VOLUME_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeModification::targetVolumeTypeAsString))
            .setter(setter(Builder::targetVolumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVolumeType")
                    .unmarshallLocationName("targetVolumeType").build()).build();

    private static final SdkField<Integer> ORIGINAL_SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(VolumeModification::originalSize))
            .setter(setter(Builder::originalSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalSize")
                    .unmarshallLocationName("originalSize").build()).build();

    private static final SdkField<Integer> ORIGINAL_IOPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(VolumeModification::originalIops))
            .setter(setter(Builder::originalIops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalIops")
                    .unmarshallLocationName("originalIops").build()).build();

    private static final SdkField<String> ORIGINAL_VOLUME_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeModification::originalVolumeTypeAsString))
            .setter(setter(Builder::originalVolumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalVolumeType")
                    .unmarshallLocationName("originalVolumeType").build()).build();

    private static final SdkField<Long> PROGRESS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(VolumeModification::progress))
            .setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress")
                    .unmarshallLocationName("progress").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(VolumeModification::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime")
                    .unmarshallLocationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(VolumeModification::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime")
                    .unmarshallLocationName("endTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD,
            MODIFICATION_STATE_FIELD, STATUS_MESSAGE_FIELD, TARGET_SIZE_FIELD, TARGET_IOPS_FIELD, TARGET_VOLUME_TYPE_FIELD,
            ORIGINAL_SIZE_FIELD, ORIGINAL_IOPS_FIELD, ORIGINAL_VOLUME_TYPE_FIELD, PROGRESS_FIELD, START_TIME_FIELD,
            END_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String volumeId;

    private final String modificationState;

    private final String statusMessage;

    private final Integer targetSize;

    private final Integer targetIops;

    private final String targetVolumeType;

    private final Integer originalSize;

    private final Integer originalIops;

    private final String originalVolumeType;

    private final Long progress;

    private final Instant startTime;

    private final Instant endTime;

    private VolumeModification(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.modificationState = builder.modificationState;
        this.statusMessage = builder.statusMessage;
        this.targetSize = builder.targetSize;
        this.targetIops = builder.targetIops;
        this.targetVolumeType = builder.targetVolumeType;
        this.originalSize = builder.originalSize;
        this.originalIops = builder.originalIops;
        this.originalVolumeType = builder.originalVolumeType;
        this.progress = builder.progress;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The current modification state. The modification state is null for unmodified volumes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modificationState}
     * will return {@link VolumeModificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #modificationStateAsString}.
     * </p>
     * 
     * @return The current modification state. The modification state is null for unmodified volumes.
     * @see VolumeModificationState
     */
    public VolumeModificationState modificationState() {
        return VolumeModificationState.fromValue(modificationState);
    }

    /**
     * <p>
     * The current modification state. The modification state is null for unmodified volumes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modificationState}
     * will return {@link VolumeModificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #modificationStateAsString}.
     * </p>
     * 
     * @return The current modification state. The modification state is null for unmodified volumes.
     * @see VolumeModificationState
     */
    public String modificationStateAsString() {
        return modificationState;
    }

    /**
     * <p>
     * A status message about the modification progress or failure.
     * </p>
     * 
     * @return A status message about the modification progress or failure.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The target size of the volume, in GiB.
     * </p>
     * 
     * @return The target size of the volume, in GiB.
     */
    public Integer targetSize() {
        return targetSize;
    }

    /**
     * <p>
     * The target IOPS rate of the volume.
     * </p>
     * 
     * @return The target IOPS rate of the volume.
     */
    public Integer targetIops() {
        return targetIops;
    }

    /**
     * <p>
     * The target EBS volume type of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetVolumeType}
     * will return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetVolumeTypeAsString}.
     * </p>
     * 
     * @return The target EBS volume type of the volume.
     * @see VolumeType
     */
    public VolumeType targetVolumeType() {
        return VolumeType.fromValue(targetVolumeType);
    }

    /**
     * <p>
     * The target EBS volume type of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetVolumeType}
     * will return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetVolumeTypeAsString}.
     * </p>
     * 
     * @return The target EBS volume type of the volume.
     * @see VolumeType
     */
    public String targetVolumeTypeAsString() {
        return targetVolumeType;
    }

    /**
     * <p>
     * The original size of the volume.
     * </p>
     * 
     * @return The original size of the volume.
     */
    public Integer originalSize() {
        return originalSize;
    }

    /**
     * <p>
     * The original IOPS rate of the volume.
     * </p>
     * 
     * @return The original IOPS rate of the volume.
     */
    public Integer originalIops() {
        return originalIops;
    }

    /**
     * <p>
     * The original EBS volume type of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originalVolumeType} will return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #originalVolumeTypeAsString}.
     * </p>
     * 
     * @return The original EBS volume type of the volume.
     * @see VolumeType
     */
    public VolumeType originalVolumeType() {
        return VolumeType.fromValue(originalVolumeType);
    }

    /**
     * <p>
     * The original EBS volume type of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originalVolumeType} will return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #originalVolumeTypeAsString}.
     * </p>
     * 
     * @return The original EBS volume type of the volume.
     * @see VolumeType
     */
    public String originalVolumeTypeAsString() {
        return originalVolumeType;
    }

    /**
     * <p>
     * The modification progress, from 0 to 100 percent complete.
     * </p>
     * 
     * @return The modification progress, from 0 to 100 percent complete.
     */
    public Long progress() {
        return progress;
    }

    /**
     * <p>
     * The modification start time.
     * </p>
     * 
     * @return The modification start time.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The modification completion or failure time.
     * </p>
     * 
     * @return The modification completion or failure time.
     */
    public Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(modificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(targetSize());
        hashCode = 31 * hashCode + Objects.hashCode(targetIops());
        hashCode = 31 * hashCode + Objects.hashCode(targetVolumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(originalSize());
        hashCode = 31 * hashCode + Objects.hashCode(originalIops());
        hashCode = 31 * hashCode + Objects.hashCode(originalVolumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeModification)) {
            return false;
        }
        VolumeModification other = (VolumeModification) obj;
        return Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(modificationStateAsString(), other.modificationStateAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(targetSize(), other.targetSize())
                && Objects.equals(targetIops(), other.targetIops())
                && Objects.equals(targetVolumeTypeAsString(), other.targetVolumeTypeAsString())
                && Objects.equals(originalSize(), other.originalSize()) && Objects.equals(originalIops(), other.originalIops())
                && Objects.equals(originalVolumeTypeAsString(), other.originalVolumeTypeAsString())
                && Objects.equals(progress(), other.progress()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VolumeModification").add("VolumeId", volumeId())
                .add("ModificationState", modificationStateAsString()).add("StatusMessage", statusMessage())
                .add("TargetSize", targetSize()).add("TargetIops", targetIops())
                .add("TargetVolumeType", targetVolumeTypeAsString()).add("OriginalSize", originalSize())
                .add("OriginalIops", originalIops()).add("OriginalVolumeType", originalVolumeTypeAsString())
                .add("Progress", progress()).add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "ModificationState":
            return Optional.ofNullable(clazz.cast(modificationStateAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "TargetSize":
            return Optional.ofNullable(clazz.cast(targetSize()));
        case "TargetIops":
            return Optional.ofNullable(clazz.cast(targetIops()));
        case "TargetVolumeType":
            return Optional.ofNullable(clazz.cast(targetVolumeTypeAsString()));
        case "OriginalSize":
            return Optional.ofNullable(clazz.cast(originalSize()));
        case "OriginalIops":
            return Optional.ofNullable(clazz.cast(originalIops()));
        case "OriginalVolumeType":
            return Optional.ofNullable(clazz.cast(originalVolumeTypeAsString()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeModification, T> g) {
        return obj -> g.apply((VolumeModification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeModification> {
        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The current modification state. The modification state is null for unmodified volumes.
         * </p>
         * 
         * @param modificationState
         *        The current modification state. The modification state is null for unmodified volumes.
         * @see VolumeModificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeModificationState
         */
        Builder modificationState(String modificationState);

        /**
         * <p>
         * The current modification state. The modification state is null for unmodified volumes.
         * </p>
         * 
         * @param modificationState
         *        The current modification state. The modification state is null for unmodified volumes.
         * @see VolumeModificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeModificationState
         */
        Builder modificationState(VolumeModificationState modificationState);

        /**
         * <p>
         * A status message about the modification progress or failure.
         * </p>
         * 
         * @param statusMessage
         *        A status message about the modification progress or failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The target size of the volume, in GiB.
         * </p>
         * 
         * @param targetSize
         *        The target size of the volume, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSize(Integer targetSize);

        /**
         * <p>
         * The target IOPS rate of the volume.
         * </p>
         * 
         * @param targetIops
         *        The target IOPS rate of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIops(Integer targetIops);

        /**
         * <p>
         * The target EBS volume type of the volume.
         * </p>
         * 
         * @param targetVolumeType
         *        The target EBS volume type of the volume.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder targetVolumeType(String targetVolumeType);

        /**
         * <p>
         * The target EBS volume type of the volume.
         * </p>
         * 
         * @param targetVolumeType
         *        The target EBS volume type of the volume.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder targetVolumeType(VolumeType targetVolumeType);

        /**
         * <p>
         * The original size of the volume.
         * </p>
         * 
         * @param originalSize
         *        The original size of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalSize(Integer originalSize);

        /**
         * <p>
         * The original IOPS rate of the volume.
         * </p>
         * 
         * @param originalIops
         *        The original IOPS rate of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalIops(Integer originalIops);

        /**
         * <p>
         * The original EBS volume type of the volume.
         * </p>
         * 
         * @param originalVolumeType
         *        The original EBS volume type of the volume.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder originalVolumeType(String originalVolumeType);

        /**
         * <p>
         * The original EBS volume type of the volume.
         * </p>
         * 
         * @param originalVolumeType
         *        The original EBS volume type of the volume.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder originalVolumeType(VolumeType originalVolumeType);

        /**
         * <p>
         * The modification progress, from 0 to 100 percent complete.
         * </p>
         * 
         * @param progress
         *        The modification progress, from 0 to 100 percent complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(Long progress);

        /**
         * <p>
         * The modification start time.
         * </p>
         * 
         * @param startTime
         *        The modification start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The modification completion or failure time.
         * </p>
         * 
         * @param endTime
         *        The modification completion or failure time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String volumeId;

        private String modificationState;

        private String statusMessage;

        private Integer targetSize;

        private Integer targetIops;

        private String targetVolumeType;

        private Integer originalSize;

        private Integer originalIops;

        private String originalVolumeType;

        private Long progress;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeModification model) {
            volumeId(model.volumeId);
            modificationState(model.modificationState);
            statusMessage(model.statusMessage);
            targetSize(model.targetSize);
            targetIops(model.targetIops);
            targetVolumeType(model.targetVolumeType);
            originalSize(model.originalSize);
            originalIops(model.originalIops);
            originalVolumeType(model.originalVolumeType);
            progress(model.progress);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final String getModificationStateAsString() {
            return modificationState;
        }

        @Override
        public final Builder modificationState(String modificationState) {
            this.modificationState = modificationState;
            return this;
        }

        @Override
        public final Builder modificationState(VolumeModificationState modificationState) {
            this.modificationState(modificationState == null ? null : modificationState.toString());
            return this;
        }

        public final void setModificationState(String modificationState) {
            this.modificationState = modificationState;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Integer getTargetSize() {
            return targetSize;
        }

        @Override
        public final Builder targetSize(Integer targetSize) {
            this.targetSize = targetSize;
            return this;
        }

        public final void setTargetSize(Integer targetSize) {
            this.targetSize = targetSize;
        }

        public final Integer getTargetIops() {
            return targetIops;
        }

        @Override
        public final Builder targetIops(Integer targetIops) {
            this.targetIops = targetIops;
            return this;
        }

        public final void setTargetIops(Integer targetIops) {
            this.targetIops = targetIops;
        }

        public final String getTargetVolumeTypeAsString() {
            return targetVolumeType;
        }

        @Override
        public final Builder targetVolumeType(String targetVolumeType) {
            this.targetVolumeType = targetVolumeType;
            return this;
        }

        @Override
        public final Builder targetVolumeType(VolumeType targetVolumeType) {
            this.targetVolumeType(targetVolumeType == null ? null : targetVolumeType.toString());
            return this;
        }

        public final void setTargetVolumeType(String targetVolumeType) {
            this.targetVolumeType = targetVolumeType;
        }

        public final Integer getOriginalSize() {
            return originalSize;
        }

        @Override
        public final Builder originalSize(Integer originalSize) {
            this.originalSize = originalSize;
            return this;
        }

        public final void setOriginalSize(Integer originalSize) {
            this.originalSize = originalSize;
        }

        public final Integer getOriginalIops() {
            return originalIops;
        }

        @Override
        public final Builder originalIops(Integer originalIops) {
            this.originalIops = originalIops;
            return this;
        }

        public final void setOriginalIops(Integer originalIops) {
            this.originalIops = originalIops;
        }

        public final String getOriginalVolumeTypeAsString() {
            return originalVolumeType;
        }

        @Override
        public final Builder originalVolumeType(String originalVolumeType) {
            this.originalVolumeType = originalVolumeType;
            return this;
        }

        @Override
        public final Builder originalVolumeType(VolumeType originalVolumeType) {
            this.originalVolumeType(originalVolumeType == null ? null : originalVolumeType.toString());
            return this;
        }

        public final void setOriginalVolumeType(String originalVolumeType) {
            this.originalVolumeType = originalVolumeType;
        }

        public final Long getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(Long progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(Long progress) {
            this.progress = progress;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public VolumeModification build() {
            return new VolumeModification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
