/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpnTunnelCertificateResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyVpnTunnelCertificateResponse.Builder, ModifyVpnTunnelCertificateResponse> {
    private static final SdkField<VpnConnection> VPN_CONNECTION_FIELD = SdkField
            .<VpnConnection> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyVpnTunnelCertificateResponse::vpnConnection))
            .setter(setter(Builder::vpnConnection))
            .constructor(VpnConnection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnection")
                    .unmarshallLocationName("vpnConnection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_FIELD));

    private final VpnConnection vpnConnection;

    private ModifyVpnTunnelCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.vpnConnection = builder.vpnConnection;
    }

    /**
     * Returns the value of the VpnConnection property for this object.
     * 
     * @return The value of the VpnConnection property for this object.
     */
    public VpnConnection vpnConnection() {
        return vpnConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnection());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpnTunnelCertificateResponse)) {
            return false;
        }
        ModifyVpnTunnelCertificateResponse other = (ModifyVpnTunnelCertificateResponse) obj;
        return Objects.equals(vpnConnection(), other.vpnConnection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyVpnTunnelCertificateResponse").add("VpnConnection", vpnConnection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnConnection":
            return Optional.ofNullable(clazz.cast(vpnConnection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpnTunnelCertificateResponse, T> g) {
        return obj -> g.apply((ModifyVpnTunnelCertificateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVpnTunnelCertificateResponse> {
        /**
         * Sets the value of the VpnConnection property for this object.
         *
         * @param vpnConnection
         *        The new value for the VpnConnection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnection(VpnConnection vpnConnection);

        /**
         * Sets the value of the VpnConnection property for this object.
         *
         * This is a convenience that creates an instance of the {@link VpnConnection.Builder} avoiding the need to
         * create one manually via {@link VpnConnection#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpnConnection.Builder#build()} is called immediately and its
         * result is passed to {@link #vpnConnection(VpnConnection)}.
         * 
         * @param vpnConnection
         *        a consumer that will call methods on {@link VpnConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpnConnection(VpnConnection)
         */
        default Builder vpnConnection(Consumer<VpnConnection.Builder> vpnConnection) {
            return vpnConnection(VpnConnection.builder().applyMutation(vpnConnection).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private VpnConnection vpnConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpnTunnelCertificateResponse model) {
            super(model);
            vpnConnection(model.vpnConnection);
        }

        public final VpnConnection.Builder getVpnConnection() {
            return vpnConnection != null ? vpnConnection.toBuilder() : null;
        }

        @Override
        public final Builder vpnConnection(VpnConnection vpnConnection) {
            this.vpnConnection = vpnConnection;
            return this;
        }

        public final void setVpnConnection(VpnConnection.BuilderImpl vpnConnection) {
            this.vpnConnection = vpnConnection != null ? vpnConnection.build() : null;
        }

        @Override
        public ModifyVpnTunnelCertificateResponse build() {
            return new ModifyVpnTunnelCertificateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
