/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyClientVpnEndpointRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyClientVpnEndpointRequest.Builder, ModifyClientVpnEndpointRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyClientVpnEndpointRequest::clientVpnEndpointId))
            .setter(setter(Builder::clientVpnEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId")
                    .unmarshallLocationName("ClientVpnEndpointId").build()).build();

    private static final SdkField<String> SERVER_CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyClientVpnEndpointRequest::serverCertificateArn))
            .setter(setter(Builder::serverCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateArn")
                    .unmarshallLocationName("ServerCertificateArn").build()).build();

    private static final SdkField<ConnectionLogOptions> CONNECTION_LOG_OPTIONS_FIELD = SdkField
            .<ConnectionLogOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyClientVpnEndpointRequest::connectionLogOptions))
            .setter(setter(Builder::connectionLogOptions))
            .constructor(ConnectionLogOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionLogOptions")
                    .unmarshallLocationName("ConnectionLogOptions").build()).build();

    private static final SdkField<DnsServersOptionsModifyStructure> DNS_SERVERS_FIELD = SdkField
            .<DnsServersOptionsModifyStructure> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyClientVpnEndpointRequest::dnsServers))
            .setter(setter(Builder::dnsServers))
            .constructor(DnsServersOptionsModifyStructure::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsServers")
                    .unmarshallLocationName("DnsServers").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyClientVpnEndpointRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<Boolean> SPLIT_TUNNEL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyClientVpnEndpointRequest::splitTunnel))
            .setter(setter(Builder::splitTunnel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitTunnel")
                    .unmarshallLocationName("SplitTunnel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, SERVER_CERTIFICATE_ARN_FIELD,
                    CONNECTION_LOG_OPTIONS_FIELD, DNS_SERVERS_FIELD, DESCRIPTION_FIELD, SPLIT_TUNNEL_FIELD));

    private final String clientVpnEndpointId;

    private final String serverCertificateArn;

    private final ConnectionLogOptions connectionLogOptions;

    private final DnsServersOptionsModifyStructure dnsServers;

    private final String description;

    private final Boolean splitTunnel;

    private ModifyClientVpnEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.serverCertificateArn = builder.serverCertificateArn;
        this.connectionLogOptions = builder.connectionLogOptions;
        this.dnsServers = builder.dnsServers;
        this.description = builder.description;
        this.splitTunnel = builder.splitTunnel;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint to modify.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint to modify.
     */
    public String clientVpnEndpointId() {
        return clientVpnEndpointId;
    }

    /**
     * <p>
     * The ARN of the server certificate to be used. The server certificate must be provisioned in AWS Certificate
     * Manager (ACM).
     * </p>
     * 
     * @return The ARN of the server certificate to be used. The server certificate must be provisioned in AWS
     *         Certificate Manager (ACM).
     */
    public String serverCertificateArn() {
        return serverCertificateArn;
    }

    /**
     * <p>
     * Information about the client connection logging options.
     * </p>
     * <p>
     * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream.
     * The following information is logged:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Client connection requests
     * </p>
     * </li>
     * <li>
     * <p>
     * Client connection results (successful and unsuccessful)
     * </p>
     * </li>
     * <li>
     * <p>
     * Reasons for unsuccessful client connection requests
     * </p>
     * </li>
     * <li>
     * <p>
     * Client connection termination time
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the client connection logging options.</p>
     *         <p>
     *         If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log
     *         stream. The following information is logged:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Client connection requests
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Client connection results (successful and unsuccessful)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reasons for unsuccessful client connection requests
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Client connection termination time
     *         </p>
     *         </li>
     */
    public ConnectionLogOptions connectionLogOptions() {
        return connectionLogOptions;
    }

    /**
     * <p>
     * Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have up to two
     * DNS servers.
     * </p>
     * 
     * @return Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have up
     *         to two DNS servers.
     */
    public DnsServersOptionsModifyStructure dnsServers() {
        return dnsServers;
    }

    /**
     * <p>
     * A brief description of the Client VPN endpoint.
     * </p>
     * 
     * @return A brief description of the Client VPN endpoint.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the VPN is split-tunnel.
     * </p>
     * <p>
     * For information about split-tunnel VPN endpoints, see <a
     * href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel AWS Client VPN
     * Endpoint</a> in the <i>AWS Client VPN Administrator Guide</i>.
     * </p>
     * 
     * @return Indicates whether the VPN is split-tunnel.</p>
     *         <p>
     *         For information about split-tunnel VPN endpoints, see <a
     *         href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel AWS
     *         Client VPN Endpoint</a> in the <i>AWS Client VPN Administrator Guide</i>.
     */
    public Boolean splitTunnel() {
        return splitTunnel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectionLogOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dnsServers());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(splitTunnel());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClientVpnEndpointRequest)) {
            return false;
        }
        ModifyClientVpnEndpointRequest other = (ModifyClientVpnEndpointRequest) obj;
        return Objects.equals(clientVpnEndpointId(), other.clientVpnEndpointId())
                && Objects.equals(serverCertificateArn(), other.serverCertificateArn())
                && Objects.equals(connectionLogOptions(), other.connectionLogOptions())
                && Objects.equals(dnsServers(), other.dnsServers()) && Objects.equals(description(), other.description())
                && Objects.equals(splitTunnel(), other.splitTunnel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyClientVpnEndpointRequest").add("ClientVpnEndpointId", clientVpnEndpointId())
                .add("ServerCertificateArn", serverCertificateArn()).add("ConnectionLogOptions", connectionLogOptions())
                .add("DnsServers", dnsServers()).add("Description", description()).add("SplitTunnel", splitTunnel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpointId":
            return Optional.ofNullable(clazz.cast(clientVpnEndpointId()));
        case "ServerCertificateArn":
            return Optional.ofNullable(clazz.cast(serverCertificateArn()));
        case "ConnectionLogOptions":
            return Optional.ofNullable(clazz.cast(connectionLogOptions()));
        case "DnsServers":
            return Optional.ofNullable(clazz.cast(dnsServers()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SplitTunnel":
            return Optional.ofNullable(clazz.cast(splitTunnel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyClientVpnEndpointRequest, T> g) {
        return obj -> g.apply((ModifyClientVpnEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyClientVpnEndpointRequest> {
        /**
         * <p>
         * The ID of the Client VPN endpoint to modify.
         * </p>
         * 
         * @param clientVpnEndpointId
         *        The ID of the Client VPN endpoint to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpointId(String clientVpnEndpointId);

        /**
         * <p>
         * The ARN of the server certificate to be used. The server certificate must be provisioned in AWS Certificate
         * Manager (ACM).
         * </p>
         * 
         * @param serverCertificateArn
         *        The ARN of the server certificate to be used. The server certificate must be provisioned in AWS
         *        Certificate Manager (ACM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateArn(String serverCertificateArn);

        /**
         * <p>
         * Information about the client connection logging options.
         * </p>
         * <p>
         * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log
         * stream. The following information is logged:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection results (successful and unsuccessful)
         * </p>
         * </li>
         * <li>
         * <p>
         * Reasons for unsuccessful client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection termination time
         * </p>
         * </li>
         * </ul>
         * 
         * @param connectionLogOptions
         *        Information about the client connection logging options.</p>
         *        <p>
         *        If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs
         *        log stream. The following information is logged:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Client connection requests
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Client connection results (successful and unsuccessful)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reasons for unsuccessful client connection requests
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Client connection termination time
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionLogOptions(ConnectionLogOptions connectionLogOptions);

        /**
         * <p>
         * Information about the client connection logging options.
         * </p>
         * <p>
         * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log
         * stream. The following information is logged:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection results (successful and unsuccessful)
         * </p>
         * </li>
         * <li>
         * <p>
         * Reasons for unsuccessful client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection termination time
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link ConnectionLogOptions.Builder} avoiding the need
         * to create one manually via {@link ConnectionLogOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionLogOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #connectionLogOptions(ConnectionLogOptions)}.
         * 
         * @param connectionLogOptions
         *        a consumer that will call methods on {@link ConnectionLogOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionLogOptions(ConnectionLogOptions)
         */
        default Builder connectionLogOptions(Consumer<ConnectionLogOptions.Builder> connectionLogOptions) {
            return connectionLogOptions(ConnectionLogOptions.builder().applyMutation(connectionLogOptions).build());
        }

        /**
         * <p>
         * Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have up to
         * two DNS servers.
         * </p>
         * 
         * @param dnsServers
         *        Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have
         *        up to two DNS servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsServers(DnsServersOptionsModifyStructure dnsServers);

        /**
         * <p>
         * Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have up to
         * two DNS servers.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsServersOptionsModifyStructure.Builder}
         * avoiding the need to create one manually via {@link DnsServersOptionsModifyStructure#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsServersOptionsModifyStructure.Builder#build()} is called
         * immediately and its result is passed to {@link #dnsServers(DnsServersOptionsModifyStructure)}.
         * 
         * @param dnsServers
         *        a consumer that will call methods on {@link DnsServersOptionsModifyStructure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsServers(DnsServersOptionsModifyStructure)
         */
        default Builder dnsServers(Consumer<DnsServersOptionsModifyStructure.Builder> dnsServers) {
            return dnsServers(DnsServersOptionsModifyStructure.builder().applyMutation(dnsServers).build());
        }

        /**
         * <p>
         * A brief description of the Client VPN endpoint.
         * </p>
         * 
         * @param description
         *        A brief description of the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the VPN is split-tunnel.
         * </p>
         * <p>
         * For information about split-tunnel VPN endpoints, see <a
         * href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel AWS Client
         * VPN Endpoint</a> in the <i>AWS Client VPN Administrator Guide</i>.
         * </p>
         * 
         * @param splitTunnel
         *        Indicates whether the VPN is split-tunnel.</p>
         *        <p>
         *        For information about split-tunnel VPN endpoints, see <a
         *        href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel AWS
         *        Client VPN Endpoint</a> in the <i>AWS Client VPN Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitTunnel(Boolean splitTunnel);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientVpnEndpointId;

        private String serverCertificateArn;

        private ConnectionLogOptions connectionLogOptions;

        private DnsServersOptionsModifyStructure dnsServers;

        private String description;

        private Boolean splitTunnel;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClientVpnEndpointRequest model) {
            super(model);
            clientVpnEndpointId(model.clientVpnEndpointId);
            serverCertificateArn(model.serverCertificateArn);
            connectionLogOptions(model.connectionLogOptions);
            dnsServers(model.dnsServers);
            description(model.description);
            splitTunnel(model.splitTunnel);
        }

        public final String getClientVpnEndpointId() {
            return clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getServerCertificateArn() {
            return serverCertificateArn;
        }

        @Override
        public final Builder serverCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public final void setServerCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
        }

        public final ConnectionLogOptions.Builder getConnectionLogOptions() {
            return connectionLogOptions != null ? connectionLogOptions.toBuilder() : null;
        }

        @Override
        public final Builder connectionLogOptions(ConnectionLogOptions connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        public final void setConnectionLogOptions(ConnectionLogOptions.BuilderImpl connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions != null ? connectionLogOptions.build() : null;
        }

        public final DnsServersOptionsModifyStructure.Builder getDnsServers() {
            return dnsServers != null ? dnsServers.toBuilder() : null;
        }

        @Override
        public final Builder dnsServers(DnsServersOptionsModifyStructure dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        public final void setDnsServers(DnsServersOptionsModifyStructure.BuilderImpl dnsServers) {
            this.dnsServers = dnsServers != null ? dnsServers.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getSplitTunnel() {
            return splitTunnel;
        }

        @Override
        public final Builder splitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        public final void setSplitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClientVpnEndpointRequest build() {
            return new ModifyClientVpnEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
