/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an error that occurred when disabling fast snapshot restores.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableFastSnapshotRestoreStateErrorItem implements SdkPojo, Serializable,
        ToCopyableBuilder<DisableFastSnapshotRestoreStateErrorItem.Builder, DisableFastSnapshotRestoreStateErrorItem> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DisableFastSnapshotRestoreStateErrorItem::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<DisableFastSnapshotRestoreStateError> ERROR_FIELD = SdkField
            .<DisableFastSnapshotRestoreStateError> builder(MarshallingType.SDK_POJO)
            .getter(getter(DisableFastSnapshotRestoreStateErrorItem::error))
            .setter(setter(Builder::error))
            .constructor(DisableFastSnapshotRestoreStateError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error")
                    .unmarshallLocationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final DisableFastSnapshotRestoreStateError error;

    private DisableFastSnapshotRestoreStateErrorItem(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.error = builder.error;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * 
     * @return The Availability Zone.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The error.
     * </p>
     * 
     * @return The error.
     */
    public DisableFastSnapshotRestoreStateError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableFastSnapshotRestoreStateErrorItem)) {
            return false;
        }
        DisableFastSnapshotRestoreStateErrorItem other = (DisableFastSnapshotRestoreStateErrorItem) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisableFastSnapshotRestoreStateErrorItem").add("AvailabilityZone", availabilityZone())
                .add("Error", error()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableFastSnapshotRestoreStateErrorItem, T> g) {
        return obj -> g.apply((DisableFastSnapshotRestoreStateErrorItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DisableFastSnapshotRestoreStateErrorItem> {
        /**
         * <p>
         * The Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The error.
         * </p>
         * 
         * @param error
         *        The error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(DisableFastSnapshotRestoreStateError error);

        /**
         * <p>
         * The error.
         * </p>
         * This is a convenience that creates an instance of the {@link DisableFastSnapshotRestoreStateError.Builder}
         * avoiding the need to create one manually via {@link DisableFastSnapshotRestoreStateError#builder()}.
         *
         * When the {@link Consumer} completes, {@link DisableFastSnapshotRestoreStateError.Builder#build()} is called
         * immediately and its result is passed to {@link #error(DisableFastSnapshotRestoreStateError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link DisableFastSnapshotRestoreStateError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(DisableFastSnapshotRestoreStateError)
         */
        default Builder error(Consumer<DisableFastSnapshotRestoreStateError.Builder> error) {
            return error(DisableFastSnapshotRestoreStateError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private DisableFastSnapshotRestoreStateError error;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableFastSnapshotRestoreStateErrorItem model) {
            availabilityZone(model.availabilityZone);
            error(model.error);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final DisableFastSnapshotRestoreStateError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        @Override
        public final Builder error(DisableFastSnapshotRestoreStateError error) {
            this.error = error;
            return this;
        }

        public final void setError(DisableFastSnapshotRestoreStateError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public DisableFastSnapshotRestoreStateErrorItem build() {
            return new DisableFastSnapshotRestoreStateErrorItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
