/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the state of a Client VPN endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientVpnEndpointStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientVpnEndpointStatus.Builder, ClientVpnEndpointStatus> {
    private static final SdkField<String> CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ClientVpnEndpointStatus::codeAsString))
            .setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code")
                    .unmarshallLocationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ClientVpnEndpointStatus::message))
            .setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message")
                    .unmarshallLocationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private ClientVpnEndpointStatus(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The state of the Client VPN endpoint. Possible states include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>pending-associate</code> - The Client VPN endpoint has been created but no target networks have been
     * associated. The Client VPN endpoint cannot accept connections.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code> - The Client VPN endpoint has been created and a target network has been associated. The
     * Client VPN endpoint can accept connections.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code> - The Client VPN endpoint is being deleted. The Client VPN endpoint cannot accept
     * connections.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code> - The Client VPN endpoint has been deleted. The Client VPN endpoint cannot accept
     * connections.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ClientVpnEndpointStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeAsString}.
     * </p>
     * 
     * @return The state of the Client VPN endpoint. Possible states include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>pending-associate</code> - The Client VPN endpoint has been created but no target networks have
     *         been associated. The Client VPN endpoint cannot accept connections.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code> - The Client VPN endpoint has been created and a target network has been
     *         associated. The Client VPN endpoint can accept connections.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code> - The Client VPN endpoint is being deleted. The Client VPN endpoint cannot accept
     *         connections.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code> - The Client VPN endpoint has been deleted. The Client VPN endpoint cannot accept
     *         connections.
     *         </p>
     *         </li>
     * @see ClientVpnEndpointStatusCode
     */
    public ClientVpnEndpointStatusCode code() {
        return ClientVpnEndpointStatusCode.fromValue(code);
    }

    /**
     * <p>
     * The state of the Client VPN endpoint. Possible states include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>pending-associate</code> - The Client VPN endpoint has been created but no target networks have been
     * associated. The Client VPN endpoint cannot accept connections.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code> - The Client VPN endpoint has been created and a target network has been associated. The
     * Client VPN endpoint can accept connections.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code> - The Client VPN endpoint is being deleted. The Client VPN endpoint cannot accept
     * connections.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code> - The Client VPN endpoint has been deleted. The Client VPN endpoint cannot accept
     * connections.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ClientVpnEndpointStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeAsString}.
     * </p>
     * 
     * @return The state of the Client VPN endpoint. Possible states include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>pending-associate</code> - The Client VPN endpoint has been created but no target networks have
     *         been associated. The Client VPN endpoint cannot accept connections.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code> - The Client VPN endpoint has been created and a target network has been
     *         associated. The Client VPN endpoint can accept connections.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code> - The Client VPN endpoint is being deleted. The Client VPN endpoint cannot accept
     *         connections.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code> - The Client VPN endpoint has been deleted. The Client VPN endpoint cannot accept
     *         connections.
     *         </p>
     *         </li>
     * @see ClientVpnEndpointStatusCode
     */
    public String codeAsString() {
        return code;
    }

    /**
     * <p>
     * A message about the status of the Client VPN endpoint.
     * </p>
     * 
     * @return A message about the status of the Client VPN endpoint.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientVpnEndpointStatus)) {
            return false;
        }
        ClientVpnEndpointStatus other = (ClientVpnEndpointStatus) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClientVpnEndpointStatus").add("Code", codeAsString()).add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientVpnEndpointStatus, T> g) {
        return obj -> g.apply((ClientVpnEndpointStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientVpnEndpointStatus> {
        /**
         * <p>
         * The state of the Client VPN endpoint. Possible states include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>pending-associate</code> - The Client VPN endpoint has been created but no target networks have been
         * associated. The Client VPN endpoint cannot accept connections.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code> - The Client VPN endpoint has been created and a target network has been associated.
         * The Client VPN endpoint can accept connections.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code> - The Client VPN endpoint is being deleted. The Client VPN endpoint cannot accept
         * connections.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code> - The Client VPN endpoint has been deleted. The Client VPN endpoint cannot accept
         * connections.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The state of the Client VPN endpoint. Possible states include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>pending-associate</code> - The Client VPN endpoint has been created but no target networks have
         *        been associated. The Client VPN endpoint cannot accept connections.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code> - The Client VPN endpoint has been created and a target network has been
         *        associated. The Client VPN endpoint can accept connections.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code> - The Client VPN endpoint is being deleted. The Client VPN endpoint cannot
         *        accept connections.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code> - The Client VPN endpoint has been deleted. The Client VPN endpoint cannot accept
         *        connections.
         *        </p>
         *        </li>
         * @see ClientVpnEndpointStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientVpnEndpointStatusCode
         */
        Builder code(String code);

        /**
         * <p>
         * The state of the Client VPN endpoint. Possible states include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>pending-associate</code> - The Client VPN endpoint has been created but no target networks have been
         * associated. The Client VPN endpoint cannot accept connections.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code> - The Client VPN endpoint has been created and a target network has been associated.
         * The Client VPN endpoint can accept connections.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code> - The Client VPN endpoint is being deleted. The Client VPN endpoint cannot accept
         * connections.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code> - The Client VPN endpoint has been deleted. The Client VPN endpoint cannot accept
         * connections.
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The state of the Client VPN endpoint. Possible states include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>pending-associate</code> - The Client VPN endpoint has been created but no target networks have
         *        been associated. The Client VPN endpoint cannot accept connections.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code> - The Client VPN endpoint has been created and a target network has been
         *        associated. The Client VPN endpoint can accept connections.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code> - The Client VPN endpoint is being deleted. The Client VPN endpoint cannot
         *        accept connections.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code> - The Client VPN endpoint has been deleted. The Client VPN endpoint cannot accept
         *        connections.
         *        </p>
         *        </li>
         * @see ClientVpnEndpointStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientVpnEndpointStatusCode
         */
        Builder code(ClientVpnEndpointStatusCode code);

        /**
         * <p>
         * A message about the status of the Client VPN endpoint.
         * </p>
         * 
         * @param message
         *        A message about the status of the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientVpnEndpointStatus model) {
            code(model.code);
            message(model.message);
        }

        public final String getCodeAsString() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(ClientVpnEndpointStatusCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public ClientVpnEndpointStatus build() {
            return new ClientVpnEndpointStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
