/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CancelSpotInstanceRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelSpotInstanceRequestsRequest extends Ec2Request implements
        ToCopyableBuilder<CancelSpotInstanceRequestsRequest.Builder, CancelSpotInstanceRequestsRequest> {
    private static final SdkField<List<String>> SPOT_INSTANCE_REQUEST_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CancelSpotInstanceRequestsRequest::spotInstanceRequestIds))
            .setter(setter(Builder::spotInstanceRequestIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId")
                    .unmarshallLocationName("SpotInstanceRequestId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SpotInstanceRequestId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SpotInstanceRequestId")
                                                    .unmarshallLocationName("SpotInstanceRequestId").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SPOT_INSTANCE_REQUEST_IDS_FIELD));

    private final List<String> spotInstanceRequestIds;

    private CancelSpotInstanceRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.spotInstanceRequestIds = builder.spotInstanceRequestIds;
    }

    /**
     * Returns true if the SpotInstanceRequestIds property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSpotInstanceRequestIds() {
        return spotInstanceRequestIds != null && !(spotInstanceRequestIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Spot Instance request IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSpotInstanceRequestIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more Spot Instance request IDs.
     */
    public List<String> spotInstanceRequestIds() {
        return spotInstanceRequestIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(spotInstanceRequestIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotInstanceRequestsRequest)) {
            return false;
        }
        CancelSpotInstanceRequestsRequest other = (CancelSpotInstanceRequestsRequest) obj;
        return Objects.equals(spotInstanceRequestIds(), other.spotInstanceRequestIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CancelSpotInstanceRequestsRequest").add("SpotInstanceRequestIds", spotInstanceRequestIds())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotInstanceRequestIds":
            return Optional.ofNullable(clazz.cast(spotInstanceRequestIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelSpotInstanceRequestsRequest, T> g) {
        return obj -> g.apply((CancelSpotInstanceRequestsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CancelSpotInstanceRequestsRequest> {
        /**
         * <p>
         * One or more Spot Instance request IDs.
         * </p>
         * 
         * @param spotInstanceRequestIds
         *        One or more Spot Instance request IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestIds(Collection<String> spotInstanceRequestIds);

        /**
         * <p>
         * One or more Spot Instance request IDs.
         * </p>
         * 
         * @param spotInstanceRequestIds
         *        One or more Spot Instance request IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestIds(String... spotInstanceRequestIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> spotInstanceRequestIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotInstanceRequestsRequest model) {
            super(model);
            spotInstanceRequestIds(model.spotInstanceRequestIds);
        }

        public final Collection<String> getSpotInstanceRequestIds() {
            return spotInstanceRequestIds;
        }

        @Override
        public final Builder spotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequestIds(String... spotInstanceRequestIds) {
            spotInstanceRequestIds(Arrays.asList(spotInstanceRequestIds));
            return this;
        }

        public final void setSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelSpotInstanceRequestsRequest build() {
            return new CancelSpotInstanceRequestsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
