/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum ResourceType {
    CLIENT_VPN_ENDPOINT("client-vpn-endpoint"),

    CUSTOMER_GATEWAY("customer-gateway"),

    DEDICATED_HOST("dedicated-host"),

    DHCP_OPTIONS("dhcp-options"),

    ELASTIC_IP("elastic-ip"),

    FLEET("fleet"),

    FPGA_IMAGE("fpga-image"),

    HOST_RESERVATION("host-reservation"),

    IMAGE("image"),

    INSTANCE("instance"),

    INTERNET_GATEWAY("internet-gateway"),

    LAUNCH_TEMPLATE("launch-template"),

    NATGATEWAY("natgateway"),

    NETWORK_ACL("network-acl"),

    NETWORK_INTERFACE("network-interface"),

    RESERVED_INSTANCES("reserved-instances"),

    ROUTE_TABLE("route-table"),

    SECURITY_GROUP("security-group"),

    SNAPSHOT("snapshot"),

    SPOT_FLEET_REQUEST("spot-fleet-request"),

    SPOT_INSTANCES_REQUEST("spot-instances-request"),

    SUBNET("subnet"),

    TRAFFIC_MIRROR_FILTER("traffic-mirror-filter"),

    TRAFFIC_MIRROR_SESSION("traffic-mirror-session"),

    TRAFFIC_MIRROR_TARGET("traffic-mirror-target"),

    TRANSIT_GATEWAY("transit-gateway"),

    TRANSIT_GATEWAY_ATTACHMENT("transit-gateway-attachment"),

    TRANSIT_GATEWAY_MULTICAST_DOMAIN("transit-gateway-multicast-domain"),

    TRANSIT_GATEWAY_ROUTE_TABLE("transit-gateway-route-table"),

    VOLUME("volume"),

    VPC("vpc"),

    VPC_PEERING_CONNECTION("vpc-peering-connection"),

    VPN_CONNECTION("vpn-connection"),

    VPN_GATEWAY("vpn-gateway"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ResourceType corresponding to the value
     */
    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ResourceType}s
     */
    public static Set<ResourceType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
