/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a local gateway virtual interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocalGatewayVirtualInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<LocalGatewayVirtualInterface.Builder, LocalGatewayVirtualInterface> {
    private static final SdkField<String> LOCAL_GATEWAY_VIRTUAL_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGatewayVirtualInterface::localGatewayVirtualInterfaceId))
            .setter(setter(Builder::localGatewayVirtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceId")
                    .unmarshallLocationName("localGatewayVirtualInterfaceId").build()).build();

    private static final SdkField<String> LOCAL_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGatewayVirtualInterface::localGatewayId))
            .setter(setter(Builder::localGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayId")
                    .unmarshallLocationName("localGatewayId").build()).build();

    private static final SdkField<Integer> VLAN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(LocalGatewayVirtualInterface::vlan))
            .setter(setter(Builder::vlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vlan")
                    .unmarshallLocationName("vlan").build()).build();

    private static final SdkField<String> LOCAL_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGatewayVirtualInterface::localAddress))
            .setter(setter(Builder::localAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalAddress")
                    .unmarshallLocationName("localAddress").build()).build();

    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(LocalGatewayVirtualInterface::peerAddress))
            .setter(setter(Builder::peerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress")
                    .unmarshallLocationName("peerAddress").build()).build();

    private static final SdkField<Integer> LOCAL_BGP_ASN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(LocalGatewayVirtualInterface::localBgpAsn))
            .setter(setter(Builder::localBgpAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalBgpAsn")
                    .unmarshallLocationName("localBgpAsn").build()).build();

    private static final SdkField<Integer> PEER_BGP_ASN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(LocalGatewayVirtualInterface::peerBgpAsn))
            .setter(setter(Builder::peerBgpAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerBgpAsn")
                    .unmarshallLocationName("peerBgpAsn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_GATEWAY_VIRTUAL_INTERFACE_ID_FIELD, LOCAL_GATEWAY_ID_FIELD, VLAN_FIELD, LOCAL_ADDRESS_FIELD,
            PEER_ADDRESS_FIELD, LOCAL_BGP_ASN_FIELD, PEER_BGP_ASN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String localGatewayVirtualInterfaceId;

    private final String localGatewayId;

    private final Integer vlan;

    private final String localAddress;

    private final String peerAddress;

    private final Integer localBgpAsn;

    private final Integer peerBgpAsn;

    private LocalGatewayVirtualInterface(BuilderImpl builder) {
        this.localGatewayVirtualInterfaceId = builder.localGatewayVirtualInterfaceId;
        this.localGatewayId = builder.localGatewayId;
        this.vlan = builder.vlan;
        this.localAddress = builder.localAddress;
        this.peerAddress = builder.peerAddress;
        this.localBgpAsn = builder.localBgpAsn;
        this.peerBgpAsn = builder.peerBgpAsn;
    }

    /**
     * <p>
     * The ID of the virtual interface.
     * </p>
     * 
     * @return The ID of the virtual interface.
     */
    public String localGatewayVirtualInterfaceId() {
        return localGatewayVirtualInterfaceId;
    }

    /**
     * <p>
     * The ID of the local gateway.
     * </p>
     * 
     * @return The ID of the local gateway.
     */
    public String localGatewayId() {
        return localGatewayId;
    }

    /**
     * <p>
     * The ID of the VLAN.
     * </p>
     * 
     * @return The ID of the VLAN.
     */
    public Integer vlan() {
        return vlan;
    }

    /**
     * <p>
     * The local address.
     * </p>
     * 
     * @return The local address.
     */
    public String localAddress() {
        return localAddress;
    }

    /**
     * <p>
     * The peer address.
     * </p>
     * 
     * @return The peer address.
     */
    public String peerAddress() {
        return peerAddress;
    }

    /**
     * <p>
     * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
     * </p>
     * 
     * @return The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
     */
    public Integer localBgpAsn() {
        return localBgpAsn;
    }

    /**
     * <p>
     * The peer BGP ASN.
     * </p>
     * 
     * @return The peer BGP ASN.
     */
    public Integer peerBgpAsn() {
        return peerBgpAsn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayVirtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(vlan());
        hashCode = 31 * hashCode + Objects.hashCode(localAddress());
        hashCode = 31 * hashCode + Objects.hashCode(peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(localBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(peerBgpAsn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalGatewayVirtualInterface)) {
            return false;
        }
        LocalGatewayVirtualInterface other = (LocalGatewayVirtualInterface) obj;
        return Objects.equals(localGatewayVirtualInterfaceId(), other.localGatewayVirtualInterfaceId())
                && Objects.equals(localGatewayId(), other.localGatewayId()) && Objects.equals(vlan(), other.vlan())
                && Objects.equals(localAddress(), other.localAddress()) && Objects.equals(peerAddress(), other.peerAddress())
                && Objects.equals(localBgpAsn(), other.localBgpAsn()) && Objects.equals(peerBgpAsn(), other.peerBgpAsn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LocalGatewayVirtualInterface")
                .add("LocalGatewayVirtualInterfaceId", localGatewayVirtualInterfaceId()).add("LocalGatewayId", localGatewayId())
                .add("Vlan", vlan()).add("LocalAddress", localAddress()).add("PeerAddress", peerAddress())
                .add("LocalBgpAsn", localBgpAsn()).add("PeerBgpAsn", peerBgpAsn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayVirtualInterfaceId":
            return Optional.ofNullable(clazz.cast(localGatewayVirtualInterfaceId()));
        case "LocalGatewayId":
            return Optional.ofNullable(clazz.cast(localGatewayId()));
        case "Vlan":
            return Optional.ofNullable(clazz.cast(vlan()));
        case "LocalAddress":
            return Optional.ofNullable(clazz.cast(localAddress()));
        case "PeerAddress":
            return Optional.ofNullable(clazz.cast(peerAddress()));
        case "LocalBgpAsn":
            return Optional.ofNullable(clazz.cast(localBgpAsn()));
        case "PeerBgpAsn":
            return Optional.ofNullable(clazz.cast(peerBgpAsn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalGatewayVirtualInterface, T> g) {
        return obj -> g.apply((LocalGatewayVirtualInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocalGatewayVirtualInterface> {
        /**
         * <p>
         * The ID of the virtual interface.
         * </p>
         * 
         * @param localGatewayVirtualInterfaceId
         *        The ID of the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayVirtualInterfaceId(String localGatewayVirtualInterfaceId);

        /**
         * <p>
         * The ID of the local gateway.
         * </p>
         * 
         * @param localGatewayId
         *        The ID of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayId(String localGatewayId);

        /**
         * <p>
         * The ID of the VLAN.
         * </p>
         * 
         * @param vlan
         *        The ID of the VLAN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vlan(Integer vlan);

        /**
         * <p>
         * The local address.
         * </p>
         * 
         * @param localAddress
         *        The local address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localAddress(String localAddress);

        /**
         * <p>
         * The peer address.
         * </p>
         * 
         * @param peerAddress
         *        The peer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAddress(String peerAddress);

        /**
         * <p>
         * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
         * </p>
         * 
         * @param localBgpAsn
         *        The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localBgpAsn(Integer localBgpAsn);

        /**
         * <p>
         * The peer BGP ASN.
         * </p>
         * 
         * @param peerBgpAsn
         *        The peer BGP ASN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerBgpAsn(Integer peerBgpAsn);
    }

    static final class BuilderImpl implements Builder {
        private String localGatewayVirtualInterfaceId;

        private String localGatewayId;

        private Integer vlan;

        private String localAddress;

        private String peerAddress;

        private Integer localBgpAsn;

        private Integer peerBgpAsn;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalGatewayVirtualInterface model) {
            localGatewayVirtualInterfaceId(model.localGatewayVirtualInterfaceId);
            localGatewayId(model.localGatewayId);
            vlan(model.vlan);
            localAddress(model.localAddress);
            peerAddress(model.peerAddress);
            localBgpAsn(model.localBgpAsn);
            peerBgpAsn(model.peerBgpAsn);
        }

        public final String getLocalGatewayVirtualInterfaceId() {
            return localGatewayVirtualInterfaceId;
        }

        @Override
        public final Builder localGatewayVirtualInterfaceId(String localGatewayVirtualInterfaceId) {
            this.localGatewayVirtualInterfaceId = localGatewayVirtualInterfaceId;
            return this;
        }

        public final void setLocalGatewayVirtualInterfaceId(String localGatewayVirtualInterfaceId) {
            this.localGatewayVirtualInterfaceId = localGatewayVirtualInterfaceId;
        }

        public final String getLocalGatewayId() {
            return localGatewayId;
        }

        @Override
        public final Builder localGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
            return this;
        }

        public final void setLocalGatewayId(String localGatewayId) {
            this.localGatewayId = localGatewayId;
        }

        public final Integer getVlan() {
            return vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        public final String getLocalAddress() {
            return localAddress;
        }

        @Override
        public final Builder localAddress(String localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public final void setLocalAddress(String localAddress) {
            this.localAddress = localAddress;
        }

        public final String getPeerAddress() {
            return peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        public final Integer getLocalBgpAsn() {
            return localBgpAsn;
        }

        @Override
        public final Builder localBgpAsn(Integer localBgpAsn) {
            this.localBgpAsn = localBgpAsn;
            return this;
        }

        public final void setLocalBgpAsn(Integer localBgpAsn) {
            this.localBgpAsn = localBgpAsn;
        }

        public final Integer getPeerBgpAsn() {
            return peerBgpAsn;
        }

        @Override
        public final Builder peerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
            return this;
        }

        public final void setPeerBgpAsn(Integer peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
        }

        @Override
        public LocalGatewayVirtualInterface build() {
            return new LocalGatewayVirtualInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
