/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCapacityReservationUsageResponse extends Ec2Response implements
        ToCopyableBuilder<GetCapacityReservationUsageResponse.Builder, GetCapacityReservationUsageResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetCapacityReservationUsageResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetCapacityReservationUsageResponse::capacityReservationId))
            .setter(setter(Builder::capacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("capacityReservationId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetCapacityReservationUsageResponse::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetCapacityReservationUsageResponse::totalInstanceCount))
            .setter(setter(Builder::totalInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount")
                    .unmarshallLocationName("totalInstanceCount").build()).build();

    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetCapacityReservationUsageResponse::availableInstanceCount))
            .setter(setter(Builder::availableInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount")
                    .unmarshallLocationName("availableInstanceCount").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetCapacityReservationUsageResponse::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<List<InstanceUsage>> INSTANCE_USAGES_FIELD = SdkField
            .<List<InstanceUsage>> builder(MarshallingType.LIST)
            .getter(getter(GetCapacityReservationUsageResponse::instanceUsages))
            .setter(setter(Builder::instanceUsages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceUsageSet")
                    .unmarshallLocationName("instanceUsageSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceUsage> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceUsage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CAPACITY_RESERVATION_ID_FIELD, INSTANCE_TYPE_FIELD, TOTAL_INSTANCE_COUNT_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD,
            STATE_FIELD, INSTANCE_USAGES_FIELD));

    private final String nextToken;

    private final String capacityReservationId;

    private final String instanceType;

    private final Integer totalInstanceCount;

    private final Integer availableInstanceCount;

    private final String state;

    private final List<InstanceUsage> instanceUsages;

    private GetCapacityReservationUsageResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.capacityReservationId = builder.capacityReservationId;
        this.instanceType = builder.instanceType;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.state = builder.state;
        this.instanceUsages = builder.instanceUsages;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the Capacity Reservation.
     */
    public String capacityReservationId() {
        return capacityReservationId;
    }

    /**
     * <p>
     * The type of instance for which the Capacity Reservation reserves capacity.
     * </p>
     * 
     * @return The type of instance for which the Capacity Reservation reserves capacity.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The number of instances for which the Capacity Reservation reserves capacity.
     * </p>
     * 
     * @return The number of instances for which the Capacity Reservation reserves capacity.
     */
    public Integer totalInstanceCount() {
        return totalInstanceCount;
    }

    /**
     * <p>
     * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
     * </p>
     * 
     * @return The remaining capacity. Indicates the number of instances that can be launched in the Capacity
     *         Reservation.
     */
    public Integer availableInstanceCount() {
        return availableInstanceCount;
    }

    /**
     * <p>
     * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
     * request. The reserved capacity is no longer available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no longer
     * available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
     * pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request
     * parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CapacityReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following
     *         states:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in
     *         your request. The reserved capacity is no longer available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no
     *         longer available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is
     *         still pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
     *         request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for
     *         60 minutes.
     *         </p>
     *         </li>
     * @see CapacityReservationState
     */
    public CapacityReservationState state() {
        return CapacityReservationState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
     * request. The reserved capacity is no longer available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no longer
     * available for your use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
     * pending.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request
     * parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CapacityReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following
     *         states:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in
     *         your request. The reserved capacity is no longer available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no
     *         longer available for your use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is
     *         still pending.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
     *         request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for
     *         60 minutes.
     *         </p>
     *         </li>
     * @see CapacityReservationState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * Returns true if the InstanceUsages property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstanceUsages() {
        return instanceUsages != null && !(instanceUsages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Capacity Reservation usage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceUsages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the Capacity Reservation usage.
     */
    public List<InstanceUsage> instanceUsages() {
        return instanceUsages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceUsages());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCapacityReservationUsageResponse)) {
            return false;
        }
        GetCapacityReservationUsageResponse other = (GetCapacityReservationUsageResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(capacityReservationId(), other.capacityReservationId())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(totalInstanceCount(), other.totalInstanceCount())
                && Objects.equals(availableInstanceCount(), other.availableInstanceCount())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(instanceUsages(), other.instanceUsages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCapacityReservationUsageResponse").add("NextToken", nextToken())
                .add("CapacityReservationId", capacityReservationId()).add("InstanceType", instanceType())
                .add("TotalInstanceCount", totalInstanceCount()).add("AvailableInstanceCount", availableInstanceCount())
                .add("State", stateAsString()).add("InstanceUsages", instanceUsages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CapacityReservationId":
            return Optional.ofNullable(clazz.cast(capacityReservationId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "TotalInstanceCount":
            return Optional.ofNullable(clazz.cast(totalInstanceCount()));
        case "AvailableInstanceCount":
            return Optional.ofNullable(clazz.cast(availableInstanceCount()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "InstanceUsages":
            return Optional.ofNullable(clazz.cast(instanceUsages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCapacityReservationUsageResponse, T> g) {
        return obj -> g.apply((GetCapacityReservationUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetCapacityReservationUsageResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationId
         *        The ID of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationId(String capacityReservationId);

        /**
         * <p>
         * The type of instance for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param instanceType
         *        The type of instance for which the Capacity Reservation reserves capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The number of instances for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param totalInstanceCount
         *        The number of instances for which the Capacity Reservation reserves capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalInstanceCount(Integer totalInstanceCount);

        /**
         * <p>
         * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
         * </p>
         * 
         * @param availableInstanceCount
         *        The remaining capacity. Indicates the number of instances that can be launched in the Capacity
         *        Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCount(Integer availableInstanceCount);

        /**
         * <p>
         * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
         * request. The reserved capacity is no longer available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no longer
         * available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
         * pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
         * request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60
         * minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following
         *        states:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified
         *        in your request. The reserved capacity is no longer available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no
         *        longer available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning
         *        is still pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
         *        request parameters, capacity constraints, or instance limit constraints. Failed requests are retained
         *        for 60 minutes.
         *        </p>
         *        </li>
         * @see CapacityReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your
         * request. The reserved capacity is no longer available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no longer
         * available for your use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still
         * pending.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
         * request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60
         * minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following
         *        states:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified
         *        in your request. The reserved capacity is no longer available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no
         *        longer available for your use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning
         *        is still pending.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid
         *        request parameters, capacity constraints, or instance limit constraints. Failed requests are retained
         *        for 60 minutes.
         *        </p>
         *        </li>
         * @see CapacityReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationState
         */
        Builder state(CapacityReservationState state);

        /**
         * <p>
         * Information about the Capacity Reservation usage.
         * </p>
         * 
         * @param instanceUsages
         *        Information about the Capacity Reservation usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceUsages(Collection<InstanceUsage> instanceUsages);

        /**
         * <p>
         * Information about the Capacity Reservation usage.
         * </p>
         * 
         * @param instanceUsages
         *        Information about the Capacity Reservation usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceUsages(InstanceUsage... instanceUsages);

        /**
         * <p>
         * Information about the Capacity Reservation usage.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceUsage>.Builder} avoiding the need
         * to create one manually via {@link List<InstanceUsage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceUsage>.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceUsages(List<InstanceUsage>)}.
         * 
         * @param instanceUsages
         *        a consumer that will call methods on {@link List<InstanceUsage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceUsages(List<InstanceUsage>)
         */
        Builder instanceUsages(Consumer<InstanceUsage.Builder>... instanceUsages);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private String capacityReservationId;

        private String instanceType;

        private Integer totalInstanceCount;

        private Integer availableInstanceCount;

        private String state;

        private List<InstanceUsage> instanceUsages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCapacityReservationUsageResponse model) {
            super(model);
            nextToken(model.nextToken);
            capacityReservationId(model.capacityReservationId);
            instanceType(model.instanceType);
            totalInstanceCount(model.totalInstanceCount);
            availableInstanceCount(model.availableInstanceCount);
            state(model.state);
            instanceUsages(model.instanceUsages);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getCapacityReservationId() {
            return capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getTotalInstanceCount() {
            return totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        public final Integer getAvailableInstanceCount() {
            return availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CapacityReservationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<InstanceUsage.Builder> getInstanceUsages() {
            return instanceUsages != null ? instanceUsages.stream().map(InstanceUsage::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder instanceUsages(Collection<InstanceUsage> instanceUsages) {
            this.instanceUsages = InstanceUsageSetCopier.copy(instanceUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceUsages(InstanceUsage... instanceUsages) {
            instanceUsages(Arrays.asList(instanceUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceUsages(Consumer<InstanceUsage.Builder>... instanceUsages) {
            instanceUsages(Stream.of(instanceUsages).map(c -> InstanceUsage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceUsages(Collection<InstanceUsage.BuilderImpl> instanceUsages) {
            this.instanceUsages = InstanceUsageSetCopier.copyFromBuilder(instanceUsages);
        }

        @Override
        public GetCapacityReservationUsageResponse build() {
            return new GetCapacityReservationUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
