/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for EnableVgwRoutePropagation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableVgwRoutePropagationRequest extends Ec2Request implements
        ToCopyableBuilder<EnableVgwRoutePropagationRequest.Builder, EnableVgwRoutePropagationRequest> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(EnableVgwRoutePropagationRequest::gatewayId))
            .setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId")
                    .unmarshallLocationName("GatewayId").build()).build();

    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(EnableVgwRoutePropagationRequest::routeTableId))
            .setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId")
                    .unmarshallLocationName("RouteTableId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            ROUTE_TABLE_ID_FIELD));

    private final String gatewayId;

    private final String routeTableId;

    private EnableVgwRoutePropagationRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.routeTableId = builder.routeTableId;
    }

    /**
     * <p>
     * The ID of the virtual private gateway that is attached to a VPC. The virtual private gateway must be attached to
     * the same VPC that the routing tables are associated with.
     * </p>
     * 
     * @return The ID of the virtual private gateway that is attached to a VPC. The virtual private gateway must be
     *         attached to the same VPC that the routing tables are associated with.
     */
    public String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The ID of the route table. The routing table must be associated with the same VPC that the virtual private
     * gateway is attached to.
     * </p>
     * 
     * @return The ID of the route table. The routing table must be associated with the same VPC that the virtual
     *         private gateway is attached to.
     */
    public String routeTableId() {
        return routeTableId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableVgwRoutePropagationRequest)) {
            return false;
        }
        EnableVgwRoutePropagationRequest other = (EnableVgwRoutePropagationRequest) obj;
        return Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(routeTableId(), other.routeTableId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EnableVgwRoutePropagationRequest").add("GatewayId", gatewayId())
                .add("RouteTableId", routeTableId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableVgwRoutePropagationRequest, T> g) {
        return obj -> g.apply((EnableVgwRoutePropagationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, EnableVgwRoutePropagationRequest> {
        /**
         * <p>
         * The ID of the virtual private gateway that is attached to a VPC. The virtual private gateway must be attached
         * to the same VPC that the routing tables are associated with.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the virtual private gateway that is attached to a VPC. The virtual private gateway must be
         *        attached to the same VPC that the routing tables are associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The ID of the route table. The routing table must be associated with the same VPC that the virtual private
         * gateway is attached to.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table. The routing table must be associated with the same VPC that the virtual
         *        private gateway is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String gatewayId;

        private String routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableVgwRoutePropagationRequest model) {
            super(model);
            gatewayId(model.gatewayId);
            routeTableId(model.routeTableId);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableVgwRoutePropagationRequest build() {
            return new EnableVgwRoutePropagationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
