/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateVpcEndpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcEndpointResponse extends Ec2Response implements
        ToCopyableBuilder<CreateVpcEndpointResponse.Builder, CreateVpcEndpointResponse> {
    private static final SdkField<VpcEndpoint> VPC_ENDPOINT_FIELD = SdkField
            .<VpcEndpoint> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateVpcEndpointResponse::vpcEndpoint))
            .setter(setter(Builder::vpcEndpoint))
            .constructor(VpcEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpoint")
                    .unmarshallLocationName("vpcEndpoint").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVpcEndpointResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_FIELD,
            CLIENT_TOKEN_FIELD));

    private final VpcEndpoint vpcEndpoint;

    private final String clientToken;

    private CreateVpcEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpoint = builder.vpcEndpoint;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the endpoint.
     * </p>
     * 
     * @return Information about the endpoint.
     */
    public VpcEndpoint vpcEndpoint() {
        return vpcEndpoint;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointResponse)) {
            return false;
        }
        CreateVpcEndpointResponse other = (CreateVpcEndpointResponse) obj;
        return Objects.equals(vpcEndpoint(), other.vpcEndpoint()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVpcEndpointResponse").add("VpcEndpoint", vpcEndpoint()).add("ClientToken", clientToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpoint":
            return Optional.ofNullable(clazz.cast(vpcEndpoint()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointResponse, T> g) {
        return obj -> g.apply((CreateVpcEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpcEndpointResponse> {
        /**
         * <p>
         * Information about the endpoint.
         * </p>
         * 
         * @param vpcEndpoint
         *        Information about the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpoint(VpcEndpoint vpcEndpoint);

        /**
         * <p>
         * Information about the endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcEndpoint.Builder} avoiding the need to create
         * one manually via {@link VpcEndpoint#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcEndpoint.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcEndpoint(VpcEndpoint)}.
         * 
         * @param vpcEndpoint
         *        a consumer that will call methods on {@link VpcEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpoint(VpcEndpoint)
         */
        default Builder vpcEndpoint(Consumer<VpcEndpoint.Builder> vpcEndpoint) {
            return vpcEndpoint(VpcEndpoint.builder().applyMutation(vpcEndpoint).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private VpcEndpoint vpcEndpoint;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointResponse model) {
            super(model);
            vpcEndpoint(model.vpcEndpoint);
            clientToken(model.clientToken);
        }

        public final VpcEndpoint.Builder getVpcEndpoint() {
            return vpcEndpoint != null ? vpcEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder vpcEndpoint(VpcEndpoint vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
            return this;
        }

        public final void setVpcEndpoint(VpcEndpoint.BuilderImpl vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint != null ? vpcEndpoint.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateVpcEndpointResponse build() {
            return new CreateVpcEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
