/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateDhcpOptionsRequest extends Ec2Request implements
        ToCopyableBuilder<AssociateDhcpOptionsRequest.Builder, AssociateDhcpOptionsRequest> {
    private static final SdkField<String> DHCP_OPTIONS_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateDhcpOptionsRequest::dhcpOptionsId))
            .setter(setter(Builder::dhcpOptionsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpOptionsId")
                    .unmarshallLocationName("DhcpOptionsId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateDhcpOptionsRequest::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DHCP_OPTIONS_ID_FIELD,
            VPC_ID_FIELD));

    private final String dhcpOptionsId;

    private final String vpcId;

    private AssociateDhcpOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The ID of the DHCP options set, or <code>default</code> to associate no DHCP options with the VPC.
     * </p>
     * 
     * @return The ID of the DHCP options set, or <code>default</code> to associate no DHCP options with the VPC.
     */
    public String dhcpOptionsId() {
        return dhcpOptionsId;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dhcpOptionsId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateDhcpOptionsRequest)) {
            return false;
        }
        AssociateDhcpOptionsRequest other = (AssociateDhcpOptionsRequest) obj;
        return Objects.equals(dhcpOptionsId(), other.dhcpOptionsId()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateDhcpOptionsRequest").add("DhcpOptionsId", dhcpOptionsId()).add("VpcId", vpcId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DhcpOptionsId":
            return Optional.ofNullable(clazz.cast(dhcpOptionsId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateDhcpOptionsRequest, T> g) {
        return obj -> g.apply((AssociateDhcpOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AssociateDhcpOptionsRequest> {
        /**
         * <p>
         * The ID of the DHCP options set, or <code>default</code> to associate no DHCP options with the VPC.
         * </p>
         * 
         * @param dhcpOptionsId
         *        The ID of the DHCP options set, or <code>default</code> to associate no DHCP options with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptionsId(String dhcpOptionsId);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String dhcpOptionsId;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateDhcpOptionsRequest model) {
            super(model);
            dhcpOptionsId(model.dhcpOptionsId);
            vpcId(model.vpcId);
        }

        public final String getDhcpOptionsId() {
            return dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateDhcpOptionsRequest build() {
            return new AssociateDhcpOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
