/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest;
import software.amazon.awssdk.services.ec2.model.PeeringConnectionOptionsRequest;

public class ModifyVpcPeeringConnectionOptionsRequestMarshaller
implements Marshaller<Request<ModifyVpcPeeringConnectionOptionsRequest>, ModifyVpcPeeringConnectionOptionsRequest> {
    public Request<ModifyVpcPeeringConnectionOptionsRequest> marshall(ModifyVpcPeeringConnectionOptionsRequest modifyVpcPeeringConnectionOptionsRequest) {
        PeeringConnectionOptionsRequest requesterPeeringConnectionOptions;
        if (modifyVpcPeeringConnectionOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifyVpcPeeringConnectionOptionsRequest, "EC2Client");
        request.addParameter("Action", "ModifyVpcPeeringConnectionOptions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        PeeringConnectionOptionsRequest accepterPeeringConnectionOptions = modifyVpcPeeringConnectionOptionsRequest.accepterPeeringConnectionOptions();
        if (accepterPeeringConnectionOptions != null) {
            if (accepterPeeringConnectionOptions.allowDnsResolutionFromRemoteVpc() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowDnsResolutionFromRemoteVpc", StringUtils.fromBoolean((Boolean)accepterPeeringConnectionOptions.allowDnsResolutionFromRemoteVpc()));
            }
            if (accepterPeeringConnectionOptions.allowEgressFromLocalClassicLinkToRemoteVpc() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowEgressFromLocalClassicLinkToRemoteVpc", StringUtils.fromBoolean((Boolean)accepterPeeringConnectionOptions.allowEgressFromLocalClassicLinkToRemoteVpc()));
            }
            if (accepterPeeringConnectionOptions.allowEgressFromLocalVpcToRemoteClassicLink() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowEgressFromLocalVpcToRemoteClassicLink", StringUtils.fromBoolean((Boolean)accepterPeeringConnectionOptions.allowEgressFromLocalVpcToRemoteClassicLink()));
            }
        }
        if ((requesterPeeringConnectionOptions = modifyVpcPeeringConnectionOptionsRequest.requesterPeeringConnectionOptions()) != null) {
            if (requesterPeeringConnectionOptions.allowDnsResolutionFromRemoteVpc() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowDnsResolutionFromRemoteVpc", StringUtils.fromBoolean((Boolean)requesterPeeringConnectionOptions.allowDnsResolutionFromRemoteVpc()));
            }
            if (requesterPeeringConnectionOptions.allowEgressFromLocalClassicLinkToRemoteVpc() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowEgressFromLocalClassicLinkToRemoteVpc", StringUtils.fromBoolean((Boolean)requesterPeeringConnectionOptions.allowEgressFromLocalClassicLinkToRemoteVpc()));
            }
            if (requesterPeeringConnectionOptions.allowEgressFromLocalVpcToRemoteClassicLink() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowEgressFromLocalVpcToRemoteClassicLink", StringUtils.fromBoolean((Boolean)requesterPeeringConnectionOptions.allowEgressFromLocalVpcToRemoteClassicLink()));
            }
        }
        if (modifyVpcPeeringConnectionOptionsRequest.vpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringUtils.fromString((String)modifyVpcPeeringConnectionOptionsRequest.vpcPeeringConnectionId()));
        }
        return request;
    }
}

