/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ec2.EC2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering;

public class DescribeReservedInstancesOfferingsPublisher
implements SdkPublisher<DescribeReservedInstancesOfferingsResponse> {
    private final EC2AsyncClient client;
    private final DescribeReservedInstancesOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedInstancesOfferingsPublisher(EC2AsyncClient client, DescribeReservedInstancesOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedInstancesOfferingsPublisher(EC2AsyncClient client, DescribeReservedInstancesOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedInstancesOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedInstancesOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ReservedInstancesOffering> reservedInstancesOfferings() {
        Function<DescribeReservedInstancesOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedInstancesOfferings() != null) {
                return response.reservedInstancesOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeReservedInstancesOfferingsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeReservedInstancesOfferingsPublisher resume(DescribeReservedInstancesOfferingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedInstancesOfferingsPublisher(this.client, (DescribeReservedInstancesOfferingsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeReservedInstancesOfferingsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReservedInstancesOfferingsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReservedInstancesOfferingsResponseFetcher
    implements AsyncPageFetcher<DescribeReservedInstancesOfferingsResponse> {
        private DescribeReservedInstancesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedInstancesOfferingsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeReservedInstancesOfferingsResponse> nextPage(DescribeReservedInstancesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedInstancesOfferingsPublisher.this.client.describeReservedInstancesOfferings(DescribeReservedInstancesOfferingsPublisher.this.firstRequest);
            }
            return DescribeReservedInstancesOfferingsPublisher.this.client.describeReservedInstancesOfferings((DescribeReservedInstancesOfferingsRequest)((Object)DescribeReservedInstancesOfferingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

