/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.TunnelOptionsListCopier;
import software.amazon.awssdk.services.ec2.model.VpnTunnelOptionsSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpnConnectionOptionsSpecification
implements ToCopyableBuilder<Builder, VpnConnectionOptionsSpecification> {
    private final Boolean staticRoutesOnly;
    private final List<VpnTunnelOptionsSpecification> tunnelOptions;

    private VpnConnectionOptionsSpecification(BuilderImpl builder) {
        this.staticRoutesOnly = builder.staticRoutesOnly;
        this.tunnelOptions = builder.tunnelOptions;
    }

    public Boolean staticRoutesOnly() {
        return this.staticRoutesOnly;
    }

    public List<VpnTunnelOptionsSpecification> tunnelOptions() {
        return this.tunnelOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.staticRoutesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnectionOptionsSpecification)) {
            return false;
        }
        VpnConnectionOptionsSpecification other = (VpnConnectionOptionsSpecification)obj;
        return Objects.equals(this.staticRoutesOnly(), other.staticRoutesOnly()) && Objects.equals(this.tunnelOptions(), other.tunnelOptions());
    }

    public String toString() {
        return ToString.builder((String)"VpnConnectionOptionsSpecification").add("StaticRoutesOnly", (Object)this.staticRoutesOnly()).add("TunnelOptions", this.tunnelOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StaticRoutesOnly": {
                return Optional.of(clazz.cast(this.staticRoutesOnly()));
            }
            case "TunnelOptions": {
                return Optional.of(clazz.cast(this.tunnelOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean staticRoutesOnly;
        private List<VpnTunnelOptionsSpecification> tunnelOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnectionOptionsSpecification model) {
            this.staticRoutesOnly(model.staticRoutesOnly);
            this.tunnelOptions(model.tunnelOptions);
        }

        public final Boolean getStaticRoutesOnly() {
            return this.staticRoutesOnly;
        }

        @Override
        public final Builder staticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        public final void setStaticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
        }

        public final Collection<VpnTunnelOptionsSpecification.Builder> getTunnelOptions() {
            return this.tunnelOptions != null ? (Collection)this.tunnelOptions.stream().map(VpnTunnelOptionsSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tunnelOptions(Collection<VpnTunnelOptionsSpecification> tunnelOptions) {
            this.tunnelOptions = TunnelOptionsListCopier.copy(tunnelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(VpnTunnelOptionsSpecification ... tunnelOptions) {
            this.tunnelOptions(Arrays.asList(tunnelOptions));
            return this;
        }

        public final void setTunnelOptions(Collection<VpnTunnelOptionsSpecification.BuilderImpl> tunnelOptions) {
            this.tunnelOptions = TunnelOptionsListCopier.copyFromBuilder(tunnelOptions);
        }

        public VpnConnectionOptionsSpecification build() {
            return new VpnConnectionOptionsSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpnConnectionOptionsSpecification> {
        public Builder staticRoutesOnly(Boolean var1);

        public Builder tunnelOptions(Collection<VpnTunnelOptionsSpecification> var1);

        public Builder tunnelOptions(VpnTunnelOptionsSpecification ... var1);
    }
}

