/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior;
import software.amazon.awssdk.services.ec2.model.LaunchSpecification;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.services.ec2.model.SpotInstanceState;
import software.amazon.awssdk.services.ec2.model.SpotInstanceStateFault;
import software.amazon.awssdk.services.ec2.model.SpotInstanceStatus;
import software.amazon.awssdk.services.ec2.model.SpotInstanceType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotInstanceRequest
implements ToCopyableBuilder<Builder, SpotInstanceRequest> {
    private final String actualBlockHourlyPrice;
    private final String availabilityZoneGroup;
    private final Integer blockDurationMinutes;
    private final Instant createTime;
    private final SpotInstanceStateFault fault;
    private final String instanceId;
    private final String launchGroup;
    private final LaunchSpecification launchSpecification;
    private final String launchedAvailabilityZone;
    private final String productDescription;
    private final String spotInstanceRequestId;
    private final String spotPrice;
    private final String state;
    private final SpotInstanceStatus status;
    private final List<Tag> tags;
    private final String type;
    private final Instant validFrom;
    private final Instant validUntil;
    private final String instanceInterruptionBehavior;

    private SpotInstanceRequest(BuilderImpl builder) {
        this.actualBlockHourlyPrice = builder.actualBlockHourlyPrice;
        this.availabilityZoneGroup = builder.availabilityZoneGroup;
        this.blockDurationMinutes = builder.blockDurationMinutes;
        this.createTime = builder.createTime;
        this.fault = builder.fault;
        this.instanceId = builder.instanceId;
        this.launchGroup = builder.launchGroup;
        this.launchSpecification = builder.launchSpecification;
        this.launchedAvailabilityZone = builder.launchedAvailabilityZone;
        this.productDescription = builder.productDescription;
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.spotPrice = builder.spotPrice;
        this.state = builder.state;
        this.status = builder.status;
        this.tags = builder.tags;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
    }

    public String actualBlockHourlyPrice() {
        return this.actualBlockHourlyPrice;
    }

    public String availabilityZoneGroup() {
        return this.availabilityZoneGroup;
    }

    public Integer blockDurationMinutes() {
        return this.blockDurationMinutes;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public SpotInstanceStateFault fault() {
        return this.fault;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String launchGroup() {
        return this.launchGroup;
    }

    public LaunchSpecification launchSpecification() {
        return this.launchSpecification;
    }

    public String launchedAvailabilityZone() {
        return this.launchedAvailabilityZone;
    }

    public RIProductDescription productDescription() {
        return RIProductDescription.fromValue(this.productDescription);
    }

    public String productDescriptionString() {
        return this.productDescription;
    }

    public String spotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public String spotPrice() {
        return this.spotPrice;
    }

    public SpotInstanceState state() {
        return SpotInstanceState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public SpotInstanceStatus status() {
        return this.status;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public SpotInstanceType type() {
        return SpotInstanceType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Instant validFrom() {
        return this.validFrom;
    }

    public Instant validUntil() {
        return this.validUntil;
    }

    public InstanceInterruptionBehavior instanceInterruptionBehavior() {
        return InstanceInterruptionBehavior.fromValue(this.instanceInterruptionBehavior);
    }

    public String instanceInterruptionBehaviorString() {
        return this.instanceInterruptionBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actualBlockHourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fault());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchedAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescriptionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotInstanceRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInterruptionBehaviorString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotInstanceRequest)) {
            return false;
        }
        SpotInstanceRequest other = (SpotInstanceRequest)obj;
        return Objects.equals(this.actualBlockHourlyPrice(), other.actualBlockHourlyPrice()) && Objects.equals(this.availabilityZoneGroup(), other.availabilityZoneGroup()) && Objects.equals(this.blockDurationMinutes(), other.blockDurationMinutes()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.fault(), other.fault()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.launchGroup(), other.launchGroup()) && Objects.equals(this.launchSpecification(), other.launchSpecification()) && Objects.equals(this.launchedAvailabilityZone(), other.launchedAvailabilityZone()) && Objects.equals(this.productDescriptionString(), other.productDescriptionString()) && Objects.equals(this.spotInstanceRequestId(), other.spotInstanceRequestId()) && Objects.equals(this.spotPrice(), other.spotPrice()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.validFrom(), other.validFrom()) && Objects.equals(this.validUntil(), other.validUntil()) && Objects.equals(this.instanceInterruptionBehaviorString(), other.instanceInterruptionBehaviorString());
    }

    public String toString() {
        return ToString.builder((String)"SpotInstanceRequest").add("ActualBlockHourlyPrice", (Object)this.actualBlockHourlyPrice()).add("AvailabilityZoneGroup", (Object)this.availabilityZoneGroup()).add("BlockDurationMinutes", (Object)this.blockDurationMinutes()).add("CreateTime", (Object)this.createTime()).add("Fault", (Object)this.fault()).add("InstanceId", (Object)this.instanceId()).add("LaunchGroup", (Object)this.launchGroup()).add("LaunchSpecification", (Object)this.launchSpecification()).add("LaunchedAvailabilityZone", (Object)this.launchedAvailabilityZone()).add("ProductDescription", (Object)this.productDescriptionString()).add("SpotInstanceRequestId", (Object)this.spotInstanceRequestId()).add("SpotPrice", (Object)this.spotPrice()).add("State", (Object)this.stateString()).add("Status", (Object)this.status()).add("Tags", this.tags()).add("Type", (Object)this.typeString()).add("ValidFrom", (Object)this.validFrom()).add("ValidUntil", (Object)this.validUntil()).add("InstanceInterruptionBehavior", (Object)this.instanceInterruptionBehaviorString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActualBlockHourlyPrice": {
                return Optional.of(clazz.cast(this.actualBlockHourlyPrice()));
            }
            case "AvailabilityZoneGroup": {
                return Optional.of(clazz.cast(this.availabilityZoneGroup()));
            }
            case "BlockDurationMinutes": {
                return Optional.of(clazz.cast(this.blockDurationMinutes()));
            }
            case "CreateTime": {
                return Optional.of(clazz.cast(this.createTime()));
            }
            case "Fault": {
                return Optional.of(clazz.cast(this.fault()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "LaunchGroup": {
                return Optional.of(clazz.cast(this.launchGroup()));
            }
            case "LaunchSpecification": {
                return Optional.of(clazz.cast(this.launchSpecification()));
            }
            case "LaunchedAvailabilityZone": {
                return Optional.of(clazz.cast(this.launchedAvailabilityZone()));
            }
            case "ProductDescription": {
                return Optional.of(clazz.cast(this.productDescriptionString()));
            }
            case "SpotInstanceRequestId": {
                return Optional.of(clazz.cast(this.spotInstanceRequestId()));
            }
            case "SpotPrice": {
                return Optional.of(clazz.cast(this.spotPrice()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "ValidFrom": {
                return Optional.of(clazz.cast(this.validFrom()));
            }
            case "ValidUntil": {
                return Optional.of(clazz.cast(this.validUntil()));
            }
            case "InstanceInterruptionBehavior": {
                return Optional.of(clazz.cast(this.instanceInterruptionBehaviorString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String actualBlockHourlyPrice;
        private String availabilityZoneGroup;
        private Integer blockDurationMinutes;
        private Instant createTime;
        private SpotInstanceStateFault fault;
        private String instanceId;
        private String launchGroup;
        private LaunchSpecification launchSpecification;
        private String launchedAvailabilityZone;
        private String productDescription;
        private String spotInstanceRequestId;
        private String spotPrice;
        private String state;
        private SpotInstanceStatus status;
        private List<Tag> tags;
        private String type;
        private Instant validFrom;
        private Instant validUntil;
        private String instanceInterruptionBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotInstanceRequest model) {
            this.actualBlockHourlyPrice(model.actualBlockHourlyPrice);
            this.availabilityZoneGroup(model.availabilityZoneGroup);
            this.blockDurationMinutes(model.blockDurationMinutes);
            this.createTime(model.createTime);
            this.fault(model.fault);
            this.instanceId(model.instanceId);
            this.launchGroup(model.launchGroup);
            this.launchSpecification(model.launchSpecification);
            this.launchedAvailabilityZone(model.launchedAvailabilityZone);
            this.productDescription(model.productDescription);
            this.spotInstanceRequestId(model.spotInstanceRequestId);
            this.spotPrice(model.spotPrice);
            this.state(model.state);
            this.status(model.status);
            this.tags(model.tags);
            this.type(model.type);
            this.validFrom(model.validFrom);
            this.validUntil(model.validUntil);
            this.instanceInterruptionBehavior(model.instanceInterruptionBehavior);
        }

        public final String getActualBlockHourlyPrice() {
            return this.actualBlockHourlyPrice;
        }

        @Override
        public final Builder actualBlockHourlyPrice(String actualBlockHourlyPrice) {
            this.actualBlockHourlyPrice = actualBlockHourlyPrice;
            return this;
        }

        public final void setActualBlockHourlyPrice(String actualBlockHourlyPrice) {
            this.actualBlockHourlyPrice = actualBlockHourlyPrice;
        }

        public final String getAvailabilityZoneGroup() {
            return this.availabilityZoneGroup;
        }

        @Override
        public final Builder availabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
            return this;
        }

        public final void setAvailabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
        }

        public final Integer getBlockDurationMinutes() {
            return this.blockDurationMinutes;
        }

        @Override
        public final Builder blockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        public final void setBlockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final SpotInstanceStateFault.Builder getFault() {
            return this.fault != null ? this.fault.toBuilder() : null;
        }

        @Override
        public final Builder fault(SpotInstanceStateFault fault) {
            this.fault = fault;
            return this;
        }

        public final void setFault(SpotInstanceStateFault.BuilderImpl fault) {
            this.fault = fault != null ? fault.build() : null;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getLaunchGroup() {
            return this.launchGroup;
        }

        @Override
        public final Builder launchGroup(String launchGroup) {
            this.launchGroup = launchGroup;
            return this;
        }

        public final void setLaunchGroup(String launchGroup) {
            this.launchGroup = launchGroup;
        }

        public final LaunchSpecification.Builder getLaunchSpecification() {
            return this.launchSpecification != null ? this.launchSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchSpecification(LaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final void setLaunchSpecification(LaunchSpecification.BuilderImpl launchSpecification) {
            this.launchSpecification = launchSpecification != null ? launchSpecification.build() : null;
        }

        public final String getLaunchedAvailabilityZone() {
            return this.launchedAvailabilityZone;
        }

        @Override
        public final Builder launchedAvailabilityZone(String launchedAvailabilityZone) {
            this.launchedAvailabilityZone = launchedAvailabilityZone;
            return this;
        }

        public final void setLaunchedAvailabilityZone(String launchedAvailabilityZone) {
            this.launchedAvailabilityZone = launchedAvailabilityZone;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getSpotInstanceRequestId() {
            return this.spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SpotInstanceState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final SpotInstanceStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(SpotInstanceStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(SpotInstanceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SpotInstanceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getValidFrom() {
            return this.validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final String getInstanceInterruptionBehavior() {
            return this.instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior.toString());
            return this;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        public SpotInstanceRequest build() {
            return new SpotInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotInstanceRequest> {
        public Builder actualBlockHourlyPrice(String var1);

        public Builder availabilityZoneGroup(String var1);

        public Builder blockDurationMinutes(Integer var1);

        public Builder createTime(Instant var1);

        public Builder fault(SpotInstanceStateFault var1);

        default public Builder fault(Consumer<SpotInstanceStateFault.Builder> fault) {
            return this.fault((SpotInstanceStateFault)((SpotInstanceStateFault.Builder)SpotInstanceStateFault.builder().apply(fault)).build());
        }

        public Builder instanceId(String var1);

        public Builder launchGroup(String var1);

        public Builder launchSpecification(LaunchSpecification var1);

        default public Builder launchSpecification(Consumer<LaunchSpecification.Builder> launchSpecification) {
            return this.launchSpecification((LaunchSpecification)((LaunchSpecification.Builder)LaunchSpecification.builder().apply(launchSpecification)).build());
        }

        public Builder launchedAvailabilityZone(String var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder spotInstanceRequestId(String var1);

        public Builder spotPrice(String var1);

        public Builder state(String var1);

        public Builder state(SpotInstanceState var1);

        public Builder status(SpotInstanceStatus var1);

        default public Builder status(Consumer<SpotInstanceStatus.Builder> status) {
            return this.status((SpotInstanceStatus)((SpotInstanceStatus.Builder)SpotInstanceStatus.builder().apply(status)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder type(String var1);

        public Builder type(SpotInstanceType var1);

        public Builder validFrom(Instant var1);

        public Builder validUntil(Instant var1);

        public Builder instanceInterruptionBehavior(String var1);

        public Builder instanceInterruptionBehavior(InstanceInterruptionBehavior var1);
    }
}

