/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrence;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScheduledInstanceAvailability
implements ToCopyableBuilder<Builder, ScheduledInstanceAvailability> {
    private final String availabilityZone;
    private final Integer availableInstanceCount;
    private final Instant firstSlotStartTime;
    private final String hourlyPrice;
    private final String instanceType;
    private final Integer maxTermDurationInDays;
    private final Integer minTermDurationInDays;
    private final String networkPlatform;
    private final String platform;
    private final String purchaseToken;
    private final ScheduledInstanceRecurrence recurrence;
    private final Integer slotDurationInHours;
    private final Integer totalScheduledInstanceHours;

    private ScheduledInstanceAvailability(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.firstSlotStartTime = builder.firstSlotStartTime;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceType = builder.instanceType;
        this.maxTermDurationInDays = builder.maxTermDurationInDays;
        this.minTermDurationInDays = builder.minTermDurationInDays;
        this.networkPlatform = builder.networkPlatform;
        this.platform = builder.platform;
        this.purchaseToken = builder.purchaseToken;
        this.recurrence = builder.recurrence;
        this.slotDurationInHours = builder.slotDurationInHours;
        this.totalScheduledInstanceHours = builder.totalScheduledInstanceHours;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Integer availableInstanceCount() {
        return this.availableInstanceCount;
    }

    public Instant firstSlotStartTime() {
        return this.firstSlotStartTime;
    }

    public String hourlyPrice() {
        return this.hourlyPrice;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer maxTermDurationInDays() {
        return this.maxTermDurationInDays;
    }

    public Integer minTermDurationInDays() {
        return this.minTermDurationInDays;
    }

    public String networkPlatform() {
        return this.networkPlatform;
    }

    public String platform() {
        return this.platform;
    }

    public String purchaseToken() {
        return this.purchaseToken;
    }

    public ScheduledInstanceRecurrence recurrence() {
        return this.recurrence;
    }

    public Integer slotDurationInHours() {
        return this.slotDurationInHours;
    }

    public Integer totalScheduledInstanceHours() {
        return this.totalScheduledInstanceHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSlotStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTermDurationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.minTermDurationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalScheduledInstanceHours());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstanceAvailability)) {
            return false;
        }
        ScheduledInstanceAvailability other = (ScheduledInstanceAvailability)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availableInstanceCount(), other.availableInstanceCount()) && Objects.equals(this.firstSlotStartTime(), other.firstSlotStartTime()) && Objects.equals(this.hourlyPrice(), other.hourlyPrice()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.maxTermDurationInDays(), other.maxTermDurationInDays()) && Objects.equals(this.minTermDurationInDays(), other.minTermDurationInDays()) && Objects.equals(this.networkPlatform(), other.networkPlatform()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.purchaseToken(), other.purchaseToken()) && Objects.equals(this.recurrence(), other.recurrence()) && Objects.equals(this.slotDurationInHours(), other.slotDurationInHours()) && Objects.equals(this.totalScheduledInstanceHours(), other.totalScheduledInstanceHours());
    }

    public String toString() {
        return ToString.builder((String)"ScheduledInstanceAvailability").add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailableInstanceCount", (Object)this.availableInstanceCount()).add("FirstSlotStartTime", (Object)this.firstSlotStartTime()).add("HourlyPrice", (Object)this.hourlyPrice()).add("InstanceType", (Object)this.instanceType()).add("MaxTermDurationInDays", (Object)this.maxTermDurationInDays()).add("MinTermDurationInDays", (Object)this.minTermDurationInDays()).add("NetworkPlatform", (Object)this.networkPlatform()).add("Platform", (Object)this.platform()).add("PurchaseToken", (Object)this.purchaseToken()).add("Recurrence", (Object)this.recurrence()).add("SlotDurationInHours", (Object)this.slotDurationInHours()).add("TotalScheduledInstanceHours", (Object)this.totalScheduledInstanceHours()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "AvailableInstanceCount": {
                return Optional.of(clazz.cast(this.availableInstanceCount()));
            }
            case "FirstSlotStartTime": {
                return Optional.of(clazz.cast(this.firstSlotStartTime()));
            }
            case "HourlyPrice": {
                return Optional.of(clazz.cast(this.hourlyPrice()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "MaxTermDurationInDays": {
                return Optional.of(clazz.cast(this.maxTermDurationInDays()));
            }
            case "MinTermDurationInDays": {
                return Optional.of(clazz.cast(this.minTermDurationInDays()));
            }
            case "NetworkPlatform": {
                return Optional.of(clazz.cast(this.networkPlatform()));
            }
            case "Platform": {
                return Optional.of(clazz.cast(this.platform()));
            }
            case "PurchaseToken": {
                return Optional.of(clazz.cast(this.purchaseToken()));
            }
            case "Recurrence": {
                return Optional.of(clazz.cast(this.recurrence()));
            }
            case "SlotDurationInHours": {
                return Optional.of(clazz.cast(this.slotDurationInHours()));
            }
            case "TotalScheduledInstanceHours": {
                return Optional.of(clazz.cast(this.totalScheduledInstanceHours()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Integer availableInstanceCount;
        private Instant firstSlotStartTime;
        private String hourlyPrice;
        private String instanceType;
        private Integer maxTermDurationInDays;
        private Integer minTermDurationInDays;
        private String networkPlatform;
        private String platform;
        private String purchaseToken;
        private ScheduledInstanceRecurrence recurrence;
        private Integer slotDurationInHours;
        private Integer totalScheduledInstanceHours;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstanceAvailability model) {
            this.availabilityZone(model.availabilityZone);
            this.availableInstanceCount(model.availableInstanceCount);
            this.firstSlotStartTime(model.firstSlotStartTime);
            this.hourlyPrice(model.hourlyPrice);
            this.instanceType(model.instanceType);
            this.maxTermDurationInDays(model.maxTermDurationInDays);
            this.minTermDurationInDays(model.minTermDurationInDays);
            this.networkPlatform(model.networkPlatform);
            this.platform(model.platform);
            this.purchaseToken(model.purchaseToken);
            this.recurrence(model.recurrence);
            this.slotDurationInHours(model.slotDurationInHours);
            this.totalScheduledInstanceHours(model.totalScheduledInstanceHours);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getAvailableInstanceCount() {
            return this.availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        public final Instant getFirstSlotStartTime() {
            return this.firstSlotStartTime;
        }

        @Override
        public final Builder firstSlotStartTime(Instant firstSlotStartTime) {
            this.firstSlotStartTime = firstSlotStartTime;
            return this;
        }

        public final void setFirstSlotStartTime(Instant firstSlotStartTime) {
            this.firstSlotStartTime = firstSlotStartTime;
        }

        public final String getHourlyPrice() {
            return this.hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getMaxTermDurationInDays() {
            return this.maxTermDurationInDays;
        }

        @Override
        public final Builder maxTermDurationInDays(Integer maxTermDurationInDays) {
            this.maxTermDurationInDays = maxTermDurationInDays;
            return this;
        }

        public final void setMaxTermDurationInDays(Integer maxTermDurationInDays) {
            this.maxTermDurationInDays = maxTermDurationInDays;
        }

        public final Integer getMinTermDurationInDays() {
            return this.minTermDurationInDays;
        }

        @Override
        public final Builder minTermDurationInDays(Integer minTermDurationInDays) {
            this.minTermDurationInDays = minTermDurationInDays;
            return this;
        }

        public final void setMinTermDurationInDays(Integer minTermDurationInDays) {
            this.minTermDurationInDays = minTermDurationInDays;
        }

        public final String getNetworkPlatform() {
            return this.networkPlatform;
        }

        @Override
        public final Builder networkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
            return this;
        }

        public final void setNetworkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getPurchaseToken() {
            return this.purchaseToken;
        }

        @Override
        public final Builder purchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
            return this;
        }

        public final void setPurchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
        }

        public final ScheduledInstanceRecurrence.Builder getRecurrence() {
            return this.recurrence != null ? this.recurrence.toBuilder() : null;
        }

        @Override
        public final Builder recurrence(ScheduledInstanceRecurrence recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(ScheduledInstanceRecurrence.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        public final Integer getSlotDurationInHours() {
            return this.slotDurationInHours;
        }

        @Override
        public final Builder slotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
            return this;
        }

        public final void setSlotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
        }

        public final Integer getTotalScheduledInstanceHours() {
            return this.totalScheduledInstanceHours;
        }

        @Override
        public final Builder totalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
            return this;
        }

        public final void setTotalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
        }

        public ScheduledInstanceAvailability build() {
            return new ScheduledInstanceAvailability(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduledInstanceAvailability> {
        public Builder availabilityZone(String var1);

        public Builder availableInstanceCount(Integer var1);

        public Builder firstSlotStartTime(Instant var1);

        public Builder hourlyPrice(String var1);

        public Builder instanceType(String var1);

        public Builder maxTermDurationInDays(Integer var1);

        public Builder minTermDurationInDays(Integer var1);

        public Builder networkPlatform(String var1);

        public Builder platform(String var1);

        public Builder purchaseToken(String var1);

        public Builder recurrence(ScheduledInstanceRecurrence var1);

        default public Builder recurrence(Consumer<ScheduledInstanceRecurrence.Builder> recurrence) {
            return this.recurrence((ScheduledInstanceRecurrence)((ScheduledInstanceRecurrence.Builder)ScheduledInstanceRecurrence.builder().apply(recurrence)).build());
        }

        public Builder slotDurationInHours(Integer var1);

        public Builder totalScheduledInstanceHours(Integer var1);
    }
}

