/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyVpcEndpointRequest
extends EC2Request
implements ToCopyableBuilder<Builder, ModifyVpcEndpointRequest> {
    private final String vpcEndpointId;
    private final Boolean resetPolicy;
    private final String policyDocument;
    private final List<String> addRouteTableIds;
    private final List<String> removeRouteTableIds;
    private final List<String> addSubnetIds;
    private final List<String> removeSubnetIds;
    private final List<String> addSecurityGroupIds;
    private final List<String> removeSecurityGroupIds;
    private final Boolean privateDnsEnabled;

    private ModifyVpcEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointId = builder.vpcEndpointId;
        this.resetPolicy = builder.resetPolicy;
        this.policyDocument = builder.policyDocument;
        this.addRouteTableIds = builder.addRouteTableIds;
        this.removeRouteTableIds = builder.removeRouteTableIds;
        this.addSubnetIds = builder.addSubnetIds;
        this.removeSubnetIds = builder.removeSubnetIds;
        this.addSecurityGroupIds = builder.addSecurityGroupIds;
        this.removeSecurityGroupIds = builder.removeSecurityGroupIds;
        this.privateDnsEnabled = builder.privateDnsEnabled;
    }

    public String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public Boolean resetPolicy() {
        return this.resetPolicy;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public List<String> addRouteTableIds() {
        return this.addRouteTableIds;
    }

    public List<String> removeRouteTableIds() {
        return this.removeRouteTableIds;
    }

    public List<String> addSubnetIds() {
        return this.addSubnetIds;
    }

    public List<String> removeSubnetIds() {
        return this.removeSubnetIds;
    }

    public List<String> addSecurityGroupIds() {
        return this.addSecurityGroupIds;
    }

    public List<String> removeSecurityGroupIds() {
        return this.removeSecurityGroupIds;
    }

    public Boolean privateDnsEnabled() {
        return this.privateDnsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resetPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.addRouteTableIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeRouteTableIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.addSubnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeSubnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.addSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointRequest)) {
            return false;
        }
        ModifyVpcEndpointRequest other = (ModifyVpcEndpointRequest)((Object)obj);
        return Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.resetPolicy(), other.resetPolicy()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.addRouteTableIds(), other.addRouteTableIds()) && Objects.equals(this.removeRouteTableIds(), other.removeRouteTableIds()) && Objects.equals(this.addSubnetIds(), other.addSubnetIds()) && Objects.equals(this.removeSubnetIds(), other.removeSubnetIds()) && Objects.equals(this.addSecurityGroupIds(), other.addSecurityGroupIds()) && Objects.equals(this.removeSecurityGroupIds(), other.removeSecurityGroupIds()) && Objects.equals(this.privateDnsEnabled(), other.privateDnsEnabled());
    }

    public String toString() {
        return ToString.builder((String)"ModifyVpcEndpointRequest").add("VpcEndpointId", (Object)this.vpcEndpointId()).add("ResetPolicy", (Object)this.resetPolicy()).add("PolicyDocument", (Object)this.policyDocument()).add("AddRouteTableIds", this.addRouteTableIds()).add("RemoveRouteTableIds", this.removeRouteTableIds()).add("AddSubnetIds", this.addSubnetIds()).add("RemoveSubnetIds", this.removeSubnetIds()).add("AddSecurityGroupIds", this.addSecurityGroupIds()).add("RemoveSecurityGroupIds", this.removeSecurityGroupIds()).add("PrivateDnsEnabled", (Object)this.privateDnsEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpointId": {
                return Optional.of(clazz.cast(this.vpcEndpointId()));
            }
            case "ResetPolicy": {
                return Optional.of(clazz.cast(this.resetPolicy()));
            }
            case "PolicyDocument": {
                return Optional.of(clazz.cast(this.policyDocument()));
            }
            case "AddRouteTableIds": {
                return Optional.of(clazz.cast(this.addRouteTableIds()));
            }
            case "RemoveRouteTableIds": {
                return Optional.of(clazz.cast(this.removeRouteTableIds()));
            }
            case "AddSubnetIds": {
                return Optional.of(clazz.cast(this.addSubnetIds()));
            }
            case "RemoveSubnetIds": {
                return Optional.of(clazz.cast(this.removeSubnetIds()));
            }
            case "AddSecurityGroupIds": {
                return Optional.of(clazz.cast(this.addSecurityGroupIds()));
            }
            case "RemoveSecurityGroupIds": {
                return Optional.of(clazz.cast(this.removeSecurityGroupIds()));
            }
            case "PrivateDnsEnabled": {
                return Optional.of(clazz.cast(this.privateDnsEnabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String vpcEndpointId;
        private Boolean resetPolicy;
        private String policyDocument;
        private List<String> addRouteTableIds;
        private List<String> removeRouteTableIds;
        private List<String> addSubnetIds;
        private List<String> removeSubnetIds;
        private List<String> addSecurityGroupIds;
        private List<String> removeSecurityGroupIds;
        private Boolean privateDnsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointRequest model) {
            this.vpcEndpointId(model.vpcEndpointId);
            this.resetPolicy(model.resetPolicy);
            this.policyDocument(model.policyDocument);
            this.addRouteTableIds(model.addRouteTableIds);
            this.removeRouteTableIds(model.removeRouteTableIds);
            this.addSubnetIds(model.addSubnetIds);
            this.removeSubnetIds(model.removeSubnetIds);
            this.addSecurityGroupIds(model.addSecurityGroupIds);
            this.removeSecurityGroupIds(model.removeSecurityGroupIds);
            this.privateDnsEnabled(model.privateDnsEnabled);
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final Boolean getResetPolicy() {
            return this.resetPolicy;
        }

        @Override
        public final Builder resetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
            return this;
        }

        public final void setResetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getAddRouteTableIds() {
            return this.addRouteTableIds;
        }

        @Override
        public final Builder addRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = ValueStringListCopier.copy(addRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addRouteTableIds(String ... addRouteTableIds) {
            this.addRouteTableIds(Arrays.asList(addRouteTableIds));
            return this;
        }

        public final void setAddRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = ValueStringListCopier.copy(addRouteTableIds);
        }

        public final Collection<String> getRemoveRouteTableIds() {
            return this.removeRouteTableIds;
        }

        @Override
        public final Builder removeRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = ValueStringListCopier.copy(removeRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRouteTableIds(String ... removeRouteTableIds) {
            this.removeRouteTableIds(Arrays.asList(removeRouteTableIds));
            return this;
        }

        public final void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = ValueStringListCopier.copy(removeRouteTableIds);
        }

        public final Collection<String> getAddSubnetIds() {
            return this.addSubnetIds;
        }

        @Override
        public final Builder addSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = ValueStringListCopier.copy(addSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSubnetIds(String ... addSubnetIds) {
            this.addSubnetIds(Arrays.asList(addSubnetIds));
            return this;
        }

        public final void setAddSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = ValueStringListCopier.copy(addSubnetIds);
        }

        public final Collection<String> getRemoveSubnetIds() {
            return this.removeSubnetIds;
        }

        @Override
        public final Builder removeSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = ValueStringListCopier.copy(removeSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSubnetIds(String ... removeSubnetIds) {
            this.removeSubnetIds(Arrays.asList(removeSubnetIds));
            return this;
        }

        public final void setRemoveSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = ValueStringListCopier.copy(removeSubnetIds);
        }

        public final Collection<String> getAddSecurityGroupIds() {
            return this.addSecurityGroupIds;
        }

        @Override
        public final Builder addSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = ValueStringListCopier.copy(addSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSecurityGroupIds(String ... addSecurityGroupIds) {
            this.addSecurityGroupIds(Arrays.asList(addSecurityGroupIds));
            return this;
        }

        public final void setAddSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = ValueStringListCopier.copy(addSecurityGroupIds);
        }

        public final Collection<String> getRemoveSecurityGroupIds() {
            return this.removeSecurityGroupIds;
        }

        @Override
        public final Builder removeSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = ValueStringListCopier.copy(removeSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSecurityGroupIds(String ... removeSecurityGroupIds) {
            this.removeSecurityGroupIds(Arrays.asList(removeSecurityGroupIds));
            return this;
        }

        public final void setRemoveSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = ValueStringListCopier.copy(removeSecurityGroupIds);
        }

        public final Boolean getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointRequest build() {
            return new ModifyVpcEndpointRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, ModifyVpcEndpointRequest> {
        public Builder vpcEndpointId(String var1);

        public Builder resetPolicy(Boolean var1);

        public Builder policyDocument(String var1);

        public Builder addRouteTableIds(Collection<String> var1);

        public Builder addRouteTableIds(String ... var1);

        public Builder removeRouteTableIds(Collection<String> var1);

        public Builder removeRouteTableIds(String ... var1);

        public Builder addSubnetIds(Collection<String> var1);

        public Builder addSubnetIds(String ... var1);

        public Builder removeSubnetIds(Collection<String> var1);

        public Builder removeSubnetIds(String ... var1);

        public Builder addSecurityGroupIds(Collection<String> var1);

        public Builder addSecurityGroupIds(String ... var1);

        public Builder removeSecurityGroupIds(Collection<String> var1);

        public Builder removeSecurityGroupIds(String ... var1);

        public Builder privateDnsEnabled(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

