/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.InstanceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceStateChange
implements ToCopyableBuilder<Builder, InstanceStateChange> {
    private final InstanceState currentState;
    private final String instanceId;
    private final InstanceState previousState;

    private InstanceStateChange(BuilderImpl builder) {
        this.currentState = builder.currentState;
        this.instanceId = builder.instanceId;
        this.previousState = builder.previousState;
    }

    public InstanceState currentState() {
        return this.currentState;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public InstanceState previousState() {
        return this.previousState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentState());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousState());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStateChange)) {
            return false;
        }
        InstanceStateChange other = (InstanceStateChange)obj;
        return Objects.equals(this.currentState(), other.currentState()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.previousState(), other.previousState());
    }

    public String toString() {
        return ToString.builder((String)"InstanceStateChange").add("CurrentState", (Object)this.currentState()).add("InstanceId", (Object)this.instanceId()).add("PreviousState", (Object)this.previousState()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentState": {
                return Optional.of(clazz.cast(this.currentState()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "PreviousState": {
                return Optional.of(clazz.cast(this.previousState()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private InstanceState currentState;
        private String instanceId;
        private InstanceState previousState;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStateChange model) {
            this.currentState(model.currentState);
            this.instanceId(model.instanceId);
            this.previousState(model.previousState);
        }

        public final InstanceState.Builder getCurrentState() {
            return this.currentState != null ? this.currentState.toBuilder() : null;
        }

        @Override
        public final Builder currentState(InstanceState currentState) {
            this.currentState = currentState;
            return this;
        }

        public final void setCurrentState(InstanceState.BuilderImpl currentState) {
            this.currentState = currentState != null ? currentState.build() : null;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final InstanceState.Builder getPreviousState() {
            return this.previousState != null ? this.previousState.toBuilder() : null;
        }

        @Override
        public final Builder previousState(InstanceState previousState) {
            this.previousState = previousState;
            return this;
        }

        public final void setPreviousState(InstanceState.BuilderImpl previousState) {
            this.previousState = previousState != null ? previousState.build() : null;
        }

        public InstanceStateChange build() {
            return new InstanceStateChange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceStateChange> {
        public Builder currentState(InstanceState var1);

        default public Builder currentState(Consumer<InstanceState.Builder> currentState) {
            return this.currentState((InstanceState)((InstanceState.Builder)InstanceState.builder().apply(currentState)).build());
        }

        public Builder instanceId(String var1);

        public Builder previousState(InstanceState var1);

        default public Builder previousState(Consumer<InstanceState.Builder> previousState) {
            return this.previousState((InstanceState)((InstanceState.Builder)InstanceState.builder().apply(previousState)).build());
        }
    }
}

