/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.ReservationValue;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValue;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValueSetCopier;
import software.amazon.awssdk.services.ec2.model.TargetReservationValue;
import software.amazon.awssdk.services.ec2.model.TargetReservationValueSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetReservedInstancesExchangeQuoteResponse
extends EC2Response
implements ToCopyableBuilder<Builder, GetReservedInstancesExchangeQuoteResponse> {
    private final String currencyCode;
    private final Boolean isValidExchange;
    private final Instant outputReservedInstancesWillExpireAt;
    private final String paymentDue;
    private final ReservationValue reservedInstanceValueRollup;
    private final List<ReservedInstanceReservationValue> reservedInstanceValueSet;
    private final ReservationValue targetConfigurationValueRollup;
    private final List<TargetReservationValue> targetConfigurationValueSet;
    private final String validationFailureReason;

    private GetReservedInstancesExchangeQuoteResponse(BuilderImpl builder) {
        super(builder);
        this.currencyCode = builder.currencyCode;
        this.isValidExchange = builder.isValidExchange;
        this.outputReservedInstancesWillExpireAt = builder.outputReservedInstancesWillExpireAt;
        this.paymentDue = builder.paymentDue;
        this.reservedInstanceValueRollup = builder.reservedInstanceValueRollup;
        this.reservedInstanceValueSet = builder.reservedInstanceValueSet;
        this.targetConfigurationValueRollup = builder.targetConfigurationValueRollup;
        this.targetConfigurationValueSet = builder.targetConfigurationValueSet;
        this.validationFailureReason = builder.validationFailureReason;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public Boolean isValidExchange() {
        return this.isValidExchange;
    }

    public Instant outputReservedInstancesWillExpireAt() {
        return this.outputReservedInstancesWillExpireAt;
    }

    public String paymentDue() {
        return this.paymentDue;
    }

    public ReservationValue reservedInstanceValueRollup() {
        return this.reservedInstanceValueRollup;
    }

    public List<ReservedInstanceReservationValue> reservedInstanceValueSet() {
        return this.reservedInstanceValueSet;
    }

    public ReservationValue targetConfigurationValueRollup() {
        return this.targetConfigurationValueRollup;
    }

    public List<TargetReservationValue> targetConfigurationValueSet() {
        return this.targetConfigurationValueSet;
    }

    public String validationFailureReason() {
        return this.validationFailureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.isValidExchange());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputReservedInstancesWillExpireAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentDue());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstanceValueRollup());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstanceValueSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfigurationValueRollup());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfigurationValueSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationFailureReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedInstancesExchangeQuoteResponse)) {
            return false;
        }
        GetReservedInstancesExchangeQuoteResponse other = (GetReservedInstancesExchangeQuoteResponse)((Object)obj);
        return Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.isValidExchange(), other.isValidExchange()) && Objects.equals(this.outputReservedInstancesWillExpireAt(), other.outputReservedInstancesWillExpireAt()) && Objects.equals(this.paymentDue(), other.paymentDue()) && Objects.equals(this.reservedInstanceValueRollup(), other.reservedInstanceValueRollup()) && Objects.equals(this.reservedInstanceValueSet(), other.reservedInstanceValueSet()) && Objects.equals(this.targetConfigurationValueRollup(), other.targetConfigurationValueRollup()) && Objects.equals(this.targetConfigurationValueSet(), other.targetConfigurationValueSet()) && Objects.equals(this.validationFailureReason(), other.validationFailureReason());
    }

    public String toString() {
        return ToString.builder((String)"GetReservedInstancesExchangeQuoteResponse").add("CurrencyCode", (Object)this.currencyCode()).add("IsValidExchange", (Object)this.isValidExchange()).add("OutputReservedInstancesWillExpireAt", (Object)this.outputReservedInstancesWillExpireAt()).add("PaymentDue", (Object)this.paymentDue()).add("ReservedInstanceValueRollup", (Object)this.reservedInstanceValueRollup()).add("ReservedInstanceValueSet", this.reservedInstanceValueSet()).add("TargetConfigurationValueRollup", (Object)this.targetConfigurationValueRollup()).add("TargetConfigurationValueSet", this.targetConfigurationValueSet()).add("ValidationFailureReason", (Object)this.validationFailureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCode()));
            }
            case "IsValidExchange": {
                return Optional.of(clazz.cast(this.isValidExchange()));
            }
            case "OutputReservedInstancesWillExpireAt": {
                return Optional.of(clazz.cast(this.outputReservedInstancesWillExpireAt()));
            }
            case "PaymentDue": {
                return Optional.of(clazz.cast(this.paymentDue()));
            }
            case "ReservedInstanceValueRollup": {
                return Optional.of(clazz.cast(this.reservedInstanceValueRollup()));
            }
            case "ReservedInstanceValueSet": {
                return Optional.of(clazz.cast(this.reservedInstanceValueSet()));
            }
            case "TargetConfigurationValueRollup": {
                return Optional.of(clazz.cast(this.targetConfigurationValueRollup()));
            }
            case "TargetConfigurationValueSet": {
                return Optional.of(clazz.cast(this.targetConfigurationValueSet()));
            }
            case "ValidationFailureReason": {
                return Optional.of(clazz.cast(this.validationFailureReason()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String currencyCode;
        private Boolean isValidExchange;
        private Instant outputReservedInstancesWillExpireAt;
        private String paymentDue;
        private ReservationValue reservedInstanceValueRollup;
        private List<ReservedInstanceReservationValue> reservedInstanceValueSet;
        private ReservationValue targetConfigurationValueRollup;
        private List<TargetReservationValue> targetConfigurationValueSet;
        private String validationFailureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedInstancesExchangeQuoteResponse model) {
            this.currencyCode(model.currencyCode);
            this.isValidExchange(model.isValidExchange);
            this.outputReservedInstancesWillExpireAt(model.outputReservedInstancesWillExpireAt);
            this.paymentDue(model.paymentDue);
            this.reservedInstanceValueRollup(model.reservedInstanceValueRollup);
            this.reservedInstanceValueSet(model.reservedInstanceValueSet);
            this.targetConfigurationValueRollup(model.targetConfigurationValueRollup);
            this.targetConfigurationValueSet(model.targetConfigurationValueSet);
            this.validationFailureReason(model.validationFailureReason);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Boolean getIsValidExchange() {
            return this.isValidExchange;
        }

        @Override
        public final Builder isValidExchange(Boolean isValidExchange) {
            this.isValidExchange = isValidExchange;
            return this;
        }

        public final void setIsValidExchange(Boolean isValidExchange) {
            this.isValidExchange = isValidExchange;
        }

        public final Instant getOutputReservedInstancesWillExpireAt() {
            return this.outputReservedInstancesWillExpireAt;
        }

        @Override
        public final Builder outputReservedInstancesWillExpireAt(Instant outputReservedInstancesWillExpireAt) {
            this.outputReservedInstancesWillExpireAt = outputReservedInstancesWillExpireAt;
            return this;
        }

        public final void setOutputReservedInstancesWillExpireAt(Instant outputReservedInstancesWillExpireAt) {
            this.outputReservedInstancesWillExpireAt = outputReservedInstancesWillExpireAt;
        }

        public final String getPaymentDue() {
            return this.paymentDue;
        }

        @Override
        public final Builder paymentDue(String paymentDue) {
            this.paymentDue = paymentDue;
            return this;
        }

        public final void setPaymentDue(String paymentDue) {
            this.paymentDue = paymentDue;
        }

        public final ReservationValue.Builder getReservedInstanceValueRollup() {
            return this.reservedInstanceValueRollup != null ? this.reservedInstanceValueRollup.toBuilder() : null;
        }

        @Override
        public final Builder reservedInstanceValueRollup(ReservationValue reservedInstanceValueRollup) {
            this.reservedInstanceValueRollup = reservedInstanceValueRollup;
            return this;
        }

        public final void setReservedInstanceValueRollup(ReservationValue.BuilderImpl reservedInstanceValueRollup) {
            this.reservedInstanceValueRollup = reservedInstanceValueRollup != null ? reservedInstanceValueRollup.build() : null;
        }

        public final Collection<ReservedInstanceReservationValue.Builder> getReservedInstanceValueSet() {
            return this.reservedInstanceValueSet != null ? (Collection)this.reservedInstanceValueSet.stream().map(ReservedInstanceReservationValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstanceValueSet(Collection<ReservedInstanceReservationValue> reservedInstanceValueSet) {
            this.reservedInstanceValueSet = ReservedInstanceReservationValueSetCopier.copy(reservedInstanceValueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceValueSet(ReservedInstanceReservationValue ... reservedInstanceValueSet) {
            this.reservedInstanceValueSet(Arrays.asList(reservedInstanceValueSet));
            return this;
        }

        public final void setReservedInstanceValueSet(Collection<ReservedInstanceReservationValue.BuilderImpl> reservedInstanceValueSet) {
            this.reservedInstanceValueSet = ReservedInstanceReservationValueSetCopier.copyFromBuilder(reservedInstanceValueSet);
        }

        public final ReservationValue.Builder getTargetConfigurationValueRollup() {
            return this.targetConfigurationValueRollup != null ? this.targetConfigurationValueRollup.toBuilder() : null;
        }

        @Override
        public final Builder targetConfigurationValueRollup(ReservationValue targetConfigurationValueRollup) {
            this.targetConfigurationValueRollup = targetConfigurationValueRollup;
            return this;
        }

        public final void setTargetConfigurationValueRollup(ReservationValue.BuilderImpl targetConfigurationValueRollup) {
            this.targetConfigurationValueRollup = targetConfigurationValueRollup != null ? targetConfigurationValueRollup.build() : null;
        }

        public final Collection<TargetReservationValue.Builder> getTargetConfigurationValueSet() {
            return this.targetConfigurationValueSet != null ? (Collection)this.targetConfigurationValueSet.stream().map(TargetReservationValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetConfigurationValueSet(Collection<TargetReservationValue> targetConfigurationValueSet) {
            this.targetConfigurationValueSet = TargetReservationValueSetCopier.copy(targetConfigurationValueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurationValueSet(TargetReservationValue ... targetConfigurationValueSet) {
            this.targetConfigurationValueSet(Arrays.asList(targetConfigurationValueSet));
            return this;
        }

        public final void setTargetConfigurationValueSet(Collection<TargetReservationValue.BuilderImpl> targetConfigurationValueSet) {
            this.targetConfigurationValueSet = TargetReservationValueSetCopier.copyFromBuilder(targetConfigurationValueSet);
        }

        public final String getValidationFailureReason() {
            return this.validationFailureReason;
        }

        @Override
        public final Builder validationFailureReason(String validationFailureReason) {
            this.validationFailureReason = validationFailureReason;
            return this;
        }

        public final void setValidationFailureReason(String validationFailureReason) {
            this.validationFailureReason = validationFailureReason;
        }

        @Override
        public GetReservedInstancesExchangeQuoteResponse build() {
            return new GetReservedInstancesExchangeQuoteResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, GetReservedInstancesExchangeQuoteResponse> {
        public Builder currencyCode(String var1);

        public Builder isValidExchange(Boolean var1);

        public Builder outputReservedInstancesWillExpireAt(Instant var1);

        public Builder paymentDue(String var1);

        public Builder reservedInstanceValueRollup(ReservationValue var1);

        default public Builder reservedInstanceValueRollup(Consumer<ReservationValue.Builder> reservedInstanceValueRollup) {
            return this.reservedInstanceValueRollup((ReservationValue)((ReservationValue.Builder)ReservationValue.builder().apply(reservedInstanceValueRollup)).build());
        }

        public Builder reservedInstanceValueSet(Collection<ReservedInstanceReservationValue> var1);

        public Builder reservedInstanceValueSet(ReservedInstanceReservationValue ... var1);

        public Builder targetConfigurationValueRollup(ReservationValue var1);

        default public Builder targetConfigurationValueRollup(Consumer<ReservationValue.Builder> targetConfigurationValueRollup) {
            return this.targetConfigurationValueRollup((ReservationValue)((ReservationValue.Builder)ReservationValue.builder().apply(targetConfigurationValueRollup)).build());
        }

        public Builder targetConfigurationValueSet(Collection<TargetReservationValue> var1);

        public Builder targetConfigurationValueSet(TargetReservationValue ... var1);

        public Builder validationFailureReason(String var1);
    }
}

