/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetConsoleOutputResponse
extends EC2Response
implements ToCopyableBuilder<Builder, GetConsoleOutputResponse> {
    private final String instanceId;
    private final String output;
    private final Instant timestamp;

    private GetConsoleOutputResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.output = builder.output;
        this.timestamp = builder.timestamp;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String output() {
        return this.output;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsoleOutputResponse)) {
            return false;
        }
        GetConsoleOutputResponse other = (GetConsoleOutputResponse)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        return ToString.builder((String)"GetConsoleOutputResponse").add("InstanceId", (Object)this.instanceId()).add("Output", (Object)this.output()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Output": {
                return Optional.of(clazz.cast(this.output()));
            }
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String instanceId;
        private String output;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsoleOutputResponse model) {
            this.instanceId(model.instanceId);
            this.output(model.output);
            this.timestamp(model.timestamp);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getOutput() {
            return this.output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public GetConsoleOutputResponse build() {
            return new GetConsoleOutputResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, GetConsoleOutputResponse> {
        public Builder instanceId(String var1);

        public Builder output(String var1);

        public Builder timestamp(Instant var1);
    }
}

