/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.ReservedInstances;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedInstancesResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeReservedInstancesResponse> {
    private final List<ReservedInstances> reservedInstances;

    private DescribeReservedInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstances = builder.reservedInstances;
    }

    public List<ReservedInstances> reservedInstances() {
        return this.reservedInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesResponse)) {
            return false;
        }
        DescribeReservedInstancesResponse other = (DescribeReservedInstancesResponse)((Object)obj);
        return Objects.equals(this.reservedInstances(), other.reservedInstances());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedInstancesResponse").add("ReservedInstances", this.reservedInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstances": {
                return Optional.of(clazz.cast(this.reservedInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<ReservedInstances> reservedInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesResponse model) {
            this.reservedInstances(model.reservedInstances);
        }

        public final Collection<ReservedInstances.Builder> getReservedInstances() {
            return this.reservedInstances != null ? (Collection)this.reservedInstances.stream().map(ReservedInstances::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstances(Collection<ReservedInstances> reservedInstances) {
            this.reservedInstances = ReservedInstancesListCopier.copy(reservedInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstances(ReservedInstances ... reservedInstances) {
            this.reservedInstances(Arrays.asList(reservedInstances));
            return this;
        }

        public final void setReservedInstances(Collection<ReservedInstances.BuilderImpl> reservedInstances) {
            this.reservedInstances = ReservedInstancesListCopier.copyFromBuilder(reservedInstances);
        }

        @Override
        public DescribeReservedInstancesResponse build() {
            return new DescribeReservedInstancesResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeReservedInstancesResponse> {
        public Builder reservedInstances(Collection<ReservedInstances> var1);

        public Builder reservedInstances(ReservedInstances ... var1);
    }
}

