/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOfferingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedInstancesOfferingsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeReservedInstancesOfferingsResponse> {
    private final List<ReservedInstancesOffering> reservedInstancesOfferings;
    private final String nextToken;

    private DescribeReservedInstancesOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesOfferings = builder.reservedInstancesOfferings;
        this.nextToken = builder.nextToken;
    }

    public List<ReservedInstancesOffering> reservedInstancesOfferings() {
        return this.reservedInstancesOfferings;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesOfferings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesOfferingsResponse)) {
            return false;
        }
        DescribeReservedInstancesOfferingsResponse other = (DescribeReservedInstancesOfferingsResponse)((Object)obj);
        return Objects.equals(this.reservedInstancesOfferings(), other.reservedInstancesOfferings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedInstancesOfferingsResponse").add("ReservedInstancesOfferings", this.reservedInstancesOfferings()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstancesOfferings": {
                return Optional.of(clazz.cast(this.reservedInstancesOfferings()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<ReservedInstancesOffering> reservedInstancesOfferings;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesOfferingsResponse model) {
            this.reservedInstancesOfferings(model.reservedInstancesOfferings);
            this.nextToken(model.nextToken);
        }

        public final Collection<ReservedInstancesOffering.Builder> getReservedInstancesOfferings() {
            return this.reservedInstancesOfferings != null ? (Collection)this.reservedInstancesOfferings.stream().map(ReservedInstancesOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstancesOfferings(Collection<ReservedInstancesOffering> reservedInstancesOfferings) {
            this.reservedInstancesOfferings = ReservedInstancesOfferingListCopier.copy(reservedInstancesOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesOfferings(ReservedInstancesOffering ... reservedInstancesOfferings) {
            this.reservedInstancesOfferings(Arrays.asList(reservedInstancesOfferings));
            return this;
        }

        public final void setReservedInstancesOfferings(Collection<ReservedInstancesOffering.BuilderImpl> reservedInstancesOfferings) {
            this.reservedInstancesOfferings = ReservedInstancesOfferingListCopier.copyFromBuilder(reservedInstancesOfferings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeReservedInstancesOfferingsResponse build() {
            return new DescribeReservedInstancesOfferingsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeReservedInstancesOfferingsResponse> {
        public Builder reservedInstancesOfferings(Collection<ReservedInstancesOffering> var1);

        public Builder reservedInstancesOfferings(ReservedInstancesOffering ... var1);

        public Builder nextToken(String var1);
    }
}

