/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.OfferingClassType;
import software.amazon.awssdk.services.ec2.model.OfferingTypeValues;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOfferingIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedInstancesOfferingsRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DescribeReservedInstancesOfferingsRequest> {
    private final String availabilityZone;
    private final List<Filter> filters;
    private final Boolean includeMarketplace;
    private final String instanceType;
    private final Long maxDuration;
    private final Integer maxInstanceCount;
    private final Long minDuration;
    private final String offeringClass;
    private final String productDescription;
    private final List<String> reservedInstancesOfferingIds;
    private final String instanceTenancy;
    private final Integer maxResults;
    private final String nextToken;
    private final String offeringType;

    private DescribeReservedInstancesOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.filters = builder.filters;
        this.includeMarketplace = builder.includeMarketplace;
        this.instanceType = builder.instanceType;
        this.maxDuration = builder.maxDuration;
        this.maxInstanceCount = builder.maxInstanceCount;
        this.minDuration = builder.minDuration;
        this.offeringClass = builder.offeringClass;
        this.productDescription = builder.productDescription;
        this.reservedInstancesOfferingIds = builder.reservedInstancesOfferingIds;
        this.instanceTenancy = builder.instanceTenancy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.offeringType = builder.offeringType;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Boolean includeMarketplace() {
        return this.includeMarketplace;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeString() {
        return this.instanceType;
    }

    public Long maxDuration() {
        return this.maxDuration;
    }

    public Integer maxInstanceCount() {
        return this.maxInstanceCount;
    }

    public Long minDuration() {
        return this.minDuration;
    }

    public OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(this.offeringClass);
    }

    public String offeringClassString() {
        return this.offeringClass;
    }

    public RIProductDescription productDescription() {
        return RIProductDescription.fromValue(this.productDescription);
    }

    public String productDescriptionString() {
        return this.productDescription;
    }

    public List<String> reservedInstancesOfferingIds() {
        return this.reservedInstancesOfferingIds;
    }

    public Tenancy instanceTenancy() {
        return Tenancy.fromValue(this.instanceTenancy);
    }

    public String instanceTenancyString() {
        return this.instanceTenancy;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(this.offeringType);
    }

    public String offeringTypeString() {
        return this.offeringType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeMarketplace());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.minDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringClassString());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescriptionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesOfferingIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesOfferingsRequest)) {
            return false;
        }
        DescribeReservedInstancesOfferingsRequest other = (DescribeReservedInstancesOfferingsRequest)((Object)obj);
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.includeMarketplace(), other.includeMarketplace()) && Objects.equals(this.instanceTypeString(), other.instanceTypeString()) && Objects.equals(this.maxDuration(), other.maxDuration()) && Objects.equals(this.maxInstanceCount(), other.maxInstanceCount()) && Objects.equals(this.minDuration(), other.minDuration()) && Objects.equals(this.offeringClassString(), other.offeringClassString()) && Objects.equals(this.productDescriptionString(), other.productDescriptionString()) && Objects.equals(this.reservedInstancesOfferingIds(), other.reservedInstancesOfferingIds()) && Objects.equals(this.instanceTenancyString(), other.instanceTenancyString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.offeringTypeString(), other.offeringTypeString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedInstancesOfferingsRequest").add("AvailabilityZone", (Object)this.availabilityZone()).add("Filters", this.filters()).add("IncludeMarketplace", (Object)this.includeMarketplace()).add("InstanceType", (Object)this.instanceTypeString()).add("MaxDuration", (Object)this.maxDuration()).add("MaxInstanceCount", (Object)this.maxInstanceCount()).add("MinDuration", (Object)this.minDuration()).add("OfferingClass", (Object)this.offeringClassString()).add("ProductDescription", (Object)this.productDescriptionString()).add("ReservedInstancesOfferingIds", this.reservedInstancesOfferingIds()).add("InstanceTenancy", (Object)this.instanceTenancyString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OfferingType", (Object)this.offeringTypeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "IncludeMarketplace": {
                return Optional.of(clazz.cast(this.includeMarketplace()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceTypeString()));
            }
            case "MaxDuration": {
                return Optional.of(clazz.cast(this.maxDuration()));
            }
            case "MaxInstanceCount": {
                return Optional.of(clazz.cast(this.maxInstanceCount()));
            }
            case "MinDuration": {
                return Optional.of(clazz.cast(this.minDuration()));
            }
            case "OfferingClass": {
                return Optional.of(clazz.cast(this.offeringClassString()));
            }
            case "ProductDescription": {
                return Optional.of(clazz.cast(this.productDescriptionString()));
            }
            case "ReservedInstancesOfferingIds": {
                return Optional.of(clazz.cast(this.reservedInstancesOfferingIds()));
            }
            case "InstanceTenancy": {
                return Optional.of(clazz.cast(this.instanceTenancyString()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "OfferingType": {
                return Optional.of(clazz.cast(this.offeringTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String availabilityZone;
        private List<Filter> filters;
        private Boolean includeMarketplace;
        private String instanceType;
        private Long maxDuration;
        private Integer maxInstanceCount;
        private Long minDuration;
        private String offeringClass;
        private String productDescription;
        private List<String> reservedInstancesOfferingIds;
        private String instanceTenancy;
        private Integer maxResults;
        private String nextToken;
        private String offeringType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesOfferingsRequest model) {
            this.availabilityZone(model.availabilityZone);
            this.filters(model.filters);
            this.includeMarketplace(model.includeMarketplace);
            this.instanceType(model.instanceType);
            this.maxDuration(model.maxDuration);
            this.maxInstanceCount(model.maxInstanceCount);
            this.minDuration(model.minDuration);
            this.offeringClass(model.offeringClass);
            this.productDescription(model.productDescription);
            this.reservedInstancesOfferingIds(model.reservedInstancesOfferingIds);
            this.instanceTenancy(model.instanceTenancy);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.offeringType(model.offeringType);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Boolean getIncludeMarketplace() {
            return this.includeMarketplace;
        }

        @Override
        public final Builder includeMarketplace(Boolean includeMarketplace) {
            this.includeMarketplace = includeMarketplace;
            return this;
        }

        public final void setIncludeMarketplace(Boolean includeMarketplace) {
            this.includeMarketplace = includeMarketplace;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Long getMaxDuration() {
            return this.maxDuration;
        }

        @Override
        public final Builder maxDuration(Long maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final void setMaxDuration(Long maxDuration) {
            this.maxDuration = maxDuration;
        }

        public final Integer getMaxInstanceCount() {
            return this.maxInstanceCount;
        }

        @Override
        public final Builder maxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
            return this;
        }

        public final void setMaxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
        }

        public final Long getMinDuration() {
            return this.minDuration;
        }

        @Override
        public final Builder minDuration(Long minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        public final void setMinDuration(Long minDuration) {
            this.minDuration = minDuration;
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final Collection<String> getReservedInstancesOfferingIds() {
            return this.reservedInstancesOfferingIds;
        }

        @Override
        public final Builder reservedInstancesOfferingIds(Collection<String> reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds = ReservedInstancesOfferingIdStringListCopier.copy(reservedInstancesOfferingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesOfferingIds(String ... reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds(Arrays.asList(reservedInstancesOfferingIds));
            return this;
        }

        public final void setReservedInstancesOfferingIds(Collection<String> reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds = ReservedInstancesOfferingIdStringListCopier.copy(reservedInstancesOfferingIds);
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedInstancesOfferingsRequest build() {
            return new DescribeReservedInstancesOfferingsRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DescribeReservedInstancesOfferingsRequest> {
        public Builder availabilityZone(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder includeMarketplace(Boolean var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder maxDuration(Long var1);

        public Builder maxInstanceCount(Integer var1);

        public Builder minDuration(Long var1);

        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClassType var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder reservedInstancesOfferingIds(Collection<String> var1);

        public Builder reservedInstancesOfferingIds(String ... var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingTypeValues var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

