/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.ImportImageTask;
import software.amazon.awssdk.services.ec2.model.ImportImageTaskListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeImportImageTasksResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeImportImageTasksResponse> {
    private final List<ImportImageTask> importImageTasks;
    private final String nextToken;

    private DescribeImportImageTasksResponse(BuilderImpl builder) {
        super(builder);
        this.importImageTasks = builder.importImageTasks;
        this.nextToken = builder.nextToken;
    }

    public List<ImportImageTask> importImageTasks() {
        return this.importImageTasks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.importImageTasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportImageTasksResponse)) {
            return false;
        }
        DescribeImportImageTasksResponse other = (DescribeImportImageTasksResponse)((Object)obj);
        return Objects.equals(this.importImageTasks(), other.importImageTasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeImportImageTasksResponse").add("ImportImageTasks", this.importImageTasks()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportImageTasks": {
                return Optional.of(clazz.cast(this.importImageTasks()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<ImportImageTask> importImageTasks;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportImageTasksResponse model) {
            this.importImageTasks(model.importImageTasks);
            this.nextToken(model.nextToken);
        }

        public final Collection<ImportImageTask.Builder> getImportImageTasks() {
            return this.importImageTasks != null ? (Collection)this.importImageTasks.stream().map(ImportImageTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder importImageTasks(Collection<ImportImageTask> importImageTasks) {
            this.importImageTasks = ImportImageTaskListCopier.copy(importImageTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importImageTasks(ImportImageTask ... importImageTasks) {
            this.importImageTasks(Arrays.asList(importImageTasks));
            return this;
        }

        public final void setImportImageTasks(Collection<ImportImageTask.BuilderImpl> importImageTasks) {
            this.importImageTasks = ImportImageTaskListCopier.copyFromBuilder(importImageTasks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImportImageTasksResponse build() {
            return new DescribeImportImageTasksResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeImportImageTasksResponse> {
        public Builder importImageTasks(Collection<ImportImageTask> var1);

        public Builder importImageTasks(ImportImageTask ... var1);

        public Builder nextToken(String var1);
    }
}

