/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteNetworkAclEntryRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DeleteNetworkAclEntryRequest> {
    private final Boolean egress;
    private final String networkAclId;
    private final Integer ruleNumber;

    private DeleteNetworkAclEntryRequest(BuilderImpl builder) {
        super(builder);
        this.egress = builder.egress;
        this.networkAclId = builder.networkAclId;
        this.ruleNumber = builder.ruleNumber;
    }

    public Boolean egress() {
        return this.egress;
    }

    public String networkAclId() {
        return this.networkAclId;
    }

    public Integer ruleNumber() {
        return this.ruleNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.egress());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkAclEntryRequest)) {
            return false;
        }
        DeleteNetworkAclEntryRequest other = (DeleteNetworkAclEntryRequest)((Object)obj);
        return Objects.equals(this.egress(), other.egress()) && Objects.equals(this.networkAclId(), other.networkAclId()) && Objects.equals(this.ruleNumber(), other.ruleNumber());
    }

    public String toString() {
        return ToString.builder((String)"DeleteNetworkAclEntryRequest").add("Egress", (Object)this.egress()).add("NetworkAclId", (Object)this.networkAclId()).add("RuleNumber", (Object)this.ruleNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Egress": {
                return Optional.of(clazz.cast(this.egress()));
            }
            case "NetworkAclId": {
                return Optional.of(clazz.cast(this.networkAclId()));
            }
            case "RuleNumber": {
                return Optional.of(clazz.cast(this.ruleNumber()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private Boolean egress;
        private String networkAclId;
        private Integer ruleNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkAclEntryRequest model) {
            this.egress(model.egress);
            this.networkAclId(model.networkAclId);
            this.ruleNumber(model.ruleNumber);
        }

        public final Boolean getEgress() {
            return this.egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        public final String getNetworkAclId() {
            return this.networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final Integer getRuleNumber() {
            return this.ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteNetworkAclEntryRequest build() {
            return new DeleteNetworkAclEntryRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DeleteNetworkAclEntryRequest> {
        public Builder egress(Boolean var1);

        public Builder networkAclId(String var1);

        public Builder ruleNumber(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

