/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsErrorItem;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsErrorSetCopier;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsSuccessItem;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsSuccessSetCopier;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelSpotFleetRequestsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, CancelSpotFleetRequestsResponse> {
    private final List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests;
    private final List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests;

    private CancelSpotFleetRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.successfulFleetRequests = builder.successfulFleetRequests;
        this.unsuccessfulFleetRequests = builder.unsuccessfulFleetRequests;
    }

    public List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests() {
        return this.successfulFleetRequests;
    }

    public List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests() {
        return this.unsuccessfulFleetRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.successfulFleetRequests());
        hashCode = 31 * hashCode + Objects.hashCode(this.unsuccessfulFleetRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsResponse)) {
            return false;
        }
        CancelSpotFleetRequestsResponse other = (CancelSpotFleetRequestsResponse)((Object)obj);
        return Objects.equals(this.successfulFleetRequests(), other.successfulFleetRequests()) && Objects.equals(this.unsuccessfulFleetRequests(), other.unsuccessfulFleetRequests());
    }

    public String toString() {
        return ToString.builder((String)"CancelSpotFleetRequestsResponse").add("SuccessfulFleetRequests", this.successfulFleetRequests()).add("UnsuccessfulFleetRequests", this.unsuccessfulFleetRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfulFleetRequests": {
                return Optional.of(clazz.cast(this.successfulFleetRequests()));
            }
            case "UnsuccessfulFleetRequests": {
                return Optional.of(clazz.cast(this.unsuccessfulFleetRequests()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests;
        private List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsResponse model) {
            this.successfulFleetRequests(model.successfulFleetRequests);
            this.unsuccessfulFleetRequests(model.unsuccessfulFleetRequests);
        }

        public final Collection<CancelSpotFleetRequestsSuccessItem.Builder> getSuccessfulFleetRequests() {
            return this.successfulFleetRequests != null ? (Collection)this.successfulFleetRequests.stream().map(CancelSpotFleetRequestsSuccessItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests) {
            this.successfulFleetRequests = CancelSpotFleetRequestsSuccessSetCopier.copy(successfulFleetRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetRequests(CancelSpotFleetRequestsSuccessItem ... successfulFleetRequests) {
            this.successfulFleetRequests(Arrays.asList(successfulFleetRequests));
            return this;
        }

        public final void setSuccessfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem.BuilderImpl> successfulFleetRequests) {
            this.successfulFleetRequests = CancelSpotFleetRequestsSuccessSetCopier.copyFromBuilder(successfulFleetRequests);
        }

        public final Collection<CancelSpotFleetRequestsErrorItem.Builder> getUnsuccessfulFleetRequests() {
            return this.unsuccessfulFleetRequests != null ? (Collection)this.unsuccessfulFleetRequests.stream().map(CancelSpotFleetRequestsErrorItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests = CancelSpotFleetRequestsErrorSetCopier.copy(unsuccessfulFleetRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFleetRequests(CancelSpotFleetRequestsErrorItem ... unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests(Arrays.asList(unsuccessfulFleetRequests));
            return this;
        }

        public final void setUnsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem.BuilderImpl> unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests = CancelSpotFleetRequestsErrorSetCopier.copyFromBuilder(unsuccessfulFleetRequests);
        }

        @Override
        public CancelSpotFleetRequestsResponse build() {
            return new CancelSpotFleetRequestsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, CancelSpotFleetRequestsResponse> {
        public Builder successfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> var1);

        public Builder successfulFleetRequests(CancelSpotFleetRequestsSuccessItem ... var1);

        public Builder unsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> var1);

        public Builder unsuccessfulFleetRequests(CancelSpotFleetRequestsErrorItem ... var1);
    }
}

