/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelSpotFleetRequestsRequest
extends EC2Request
implements ToCopyableBuilder<Builder, CancelSpotFleetRequestsRequest> {
    private final List<String> spotFleetRequestIds;
    private final Boolean terminateInstances;

    private CancelSpotFleetRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.spotFleetRequestIds = builder.spotFleetRequestIds;
        this.terminateInstances = builder.terminateInstances;
    }

    public List<String> spotFleetRequestIds() {
        return this.spotFleetRequestIds;
    }

    public Boolean terminateInstances() {
        return this.terminateInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsRequest)) {
            return false;
        }
        CancelSpotFleetRequestsRequest other = (CancelSpotFleetRequestsRequest)((Object)obj);
        return Objects.equals(this.spotFleetRequestIds(), other.spotFleetRequestIds()) && Objects.equals(this.terminateInstances(), other.terminateInstances());
    }

    public String toString() {
        return ToString.builder((String)"CancelSpotFleetRequestsRequest").add("SpotFleetRequestIds", this.spotFleetRequestIds()).add("TerminateInstances", (Object)this.terminateInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpotFleetRequestIds": {
                return Optional.of(clazz.cast(this.spotFleetRequestIds()));
            }
            case "TerminateInstances": {
                return Optional.of(clazz.cast(this.terminateInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<String> spotFleetRequestIds;
        private Boolean terminateInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsRequest model) {
            this.spotFleetRequestIds(model.spotFleetRequestIds);
            this.terminateInstances(model.terminateInstances);
        }

        public final Collection<String> getSpotFleetRequestIds() {
            return this.spotFleetRequestIds;
        }

        @Override
        public final Builder spotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = ValueStringListCopier.copy(spotFleetRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestIds(String ... spotFleetRequestIds) {
            this.spotFleetRequestIds(Arrays.asList(spotFleetRequestIds));
            return this;
        }

        public final void setSpotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = ValueStringListCopier.copy(spotFleetRequestIds);
        }

        public final Boolean getTerminateInstances() {
            return this.terminateInstances;
        }

        @Override
        public final Builder terminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
            return this;
        }

        public final void setTerminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CancelSpotFleetRequestsRequest build() {
            return new CancelSpotFleetRequestsRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, CancelSpotFleetRequestsRequest> {
        public Builder spotFleetRequestIds(Collection<String> var1);

        public Builder spotFleetRequestIds(String ... var1);

        public Builder terminateInstances(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

