/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.BundleTaskError;
import software.amazon.awssdk.services.ec2.model.BundleTaskState;
import software.amazon.awssdk.services.ec2.model.Storage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BundleTask
implements ToCopyableBuilder<Builder, BundleTask> {
    private final String bundleId;
    private final BundleTaskError bundleTaskError;
    private final String instanceId;
    private final String progress;
    private final Instant startTime;
    private final String state;
    private final Storage storage;
    private final Instant updateTime;

    private BundleTask(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.bundleTaskError = builder.bundleTaskError;
        this.instanceId = builder.instanceId;
        this.progress = builder.progress;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.storage = builder.storage;
        this.updateTime = builder.updateTime;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public BundleTaskError bundleTaskError() {
        return this.bundleTaskError;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String progress() {
        return this.progress;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public BundleTaskState state() {
        return BundleTaskState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public Storage storage() {
        return this.storage;
    }

    public Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleTaskError());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storage());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleTask)) {
            return false;
        }
        BundleTask other = (BundleTask)obj;
        return Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.bundleTaskError(), other.bundleTaskError()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.storage(), other.storage()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public String toString() {
        return ToString.builder((String)"BundleTask").add("BundleId", (Object)this.bundleId()).add("BundleTaskError", (Object)this.bundleTaskError()).add("InstanceId", (Object)this.instanceId()).add("Progress", (Object)this.progress()).add("StartTime", (Object)this.startTime()).add("State", (Object)this.stateString()).add("Storage", (Object)this.storage()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BundleId": {
                return Optional.of(clazz.cast(this.bundleId()));
            }
            case "BundleTaskError": {
                return Optional.of(clazz.cast(this.bundleTaskError()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Progress": {
                return Optional.of(clazz.cast(this.progress()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "Storage": {
                return Optional.of(clazz.cast(this.storage()));
            }
            case "UpdateTime": {
                return Optional.of(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String bundleId;
        private BundleTaskError bundleTaskError;
        private String instanceId;
        private String progress;
        private Instant startTime;
        private String state;
        private Storage storage;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BundleTask model) {
            this.bundleId(model.bundleId);
            this.bundleTaskError(model.bundleTaskError);
            this.instanceId(model.instanceId);
            this.progress(model.progress);
            this.startTime(model.startTime);
            this.state(model.state);
            this.storage(model.storage);
            this.updateTime(model.updateTime);
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final BundleTaskError.Builder getBundleTaskError() {
            return this.bundleTaskError != null ? this.bundleTaskError.toBuilder() : null;
        }

        @Override
        public final Builder bundleTaskError(BundleTaskError bundleTaskError) {
            this.bundleTaskError = bundleTaskError;
            return this;
        }

        public final void setBundleTaskError(BundleTaskError.BuilderImpl bundleTaskError) {
            this.bundleTaskError = bundleTaskError != null ? bundleTaskError.build() : null;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(BundleTaskState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Storage.Builder getStorage() {
            return this.storage != null ? this.storage.toBuilder() : null;
        }

        @Override
        public final Builder storage(Storage storage) {
            this.storage = storage;
            return this;
        }

        public final void setStorage(Storage.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public BundleTask build() {
            return new BundleTask(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BundleTask> {
        public Builder bundleId(String var1);

        public Builder bundleTaskError(BundleTaskError var1);

        default public Builder bundleTaskError(Consumer<BundleTaskError.Builder> bundleTaskError) {
            return this.bundleTaskError((BundleTaskError)((BundleTaskError.Builder)BundleTaskError.builder().apply(bundleTaskError)).build());
        }

        public Builder instanceId(String var1);

        public Builder progress(String var1);

        public Builder startTime(Instant var1);

        public Builder state(String var1);

        public Builder state(BundleTaskState var1);

        public Builder storage(Storage var1);

        default public Builder storage(Consumer<Storage.Builder> storage) {
            return this.storage((Storage)((Storage.Builder)Storage.builder().apply(storage)).build());
        }

        public Builder updateTime(Instant var1);
    }
}

