/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * StaleSecurityGroup StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class StaleSecurityGroupUnmarshaller implements Unmarshaller<StaleSecurityGroup, StaxUnmarshallerContext> {

    public StaleSecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        StaleSecurityGroup.Builder staleSecurityGroup = StaleSecurityGroup.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<StaleIpPermission> staleIpPermissions = null;
        java.util.List<StaleIpPermission> staleIpPermissionsEgress = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                staleSecurityGroup.staleIpPermissions(staleIpPermissions);
                staleSecurityGroup.staleIpPermissionsEgress(staleIpPermissionsEgress);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("description", targetDepth)) {
                    staleSecurityGroup.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("groupId", targetDepth)) {
                    staleSecurityGroup.groupId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("groupName", targetDepth)) {
                    staleSecurityGroup.groupName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("staleIpPermissions", targetDepth)) {
                    staleIpPermissions = new ArrayList<StaleIpPermission>();
                    continue;
                }

                if (context.testExpression("staleIpPermissions/item", targetDepth)) {
                    staleIpPermissions.add(StaleIpPermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("staleIpPermissionsEgress", targetDepth)) {
                    staleIpPermissionsEgress = new ArrayList<StaleIpPermission>();
                    continue;
                }

                if (context.testExpression("staleIpPermissionsEgress/item", targetDepth)) {
                    staleIpPermissionsEgress.add(StaleIpPermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpcId", targetDepth)) {
                    staleSecurityGroup.vpcId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    staleSecurityGroup.staleIpPermissions(staleIpPermissions);
                    staleSecurityGroup.staleIpPermissionsEgress(staleIpPermissionsEgress);
                    break;
                }
            }
        }
        return staleSecurityGroup.build();
    }

    private static final StaleSecurityGroupUnmarshaller INSTANCE = new StaleSecurityGroupUnmarshaller();

    public static StaleSecurityGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}
