/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ScheduledInstancesNetworkInterface StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ScheduledInstancesNetworkInterfaceUnmarshaller implements
        Unmarshaller<ScheduledInstancesNetworkInterface, StaxUnmarshallerContext> {

    public ScheduledInstancesNetworkInterface unmarshall(StaxUnmarshallerContext context) throws Exception {
        ScheduledInstancesNetworkInterface.Builder scheduledInstancesNetworkInterface = ScheduledInstancesNetworkInterface
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> groups = null;
        java.util.List<ScheduledInstancesIpv6Address> ipv6Addresses = null;
        java.util.List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                scheduledInstancesNetworkInterface.groups(groups);
                scheduledInstancesNetworkInterface.ipv6Addresses(ipv6Addresses);
                scheduledInstancesNetworkInterface.privateIpAddressConfigs(privateIpAddressConfigs);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("AssociatePublicIpAddress", targetDepth)) {
                    scheduledInstancesNetworkInterface.associatePublicIpAddress(BooleanUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("DeleteOnTermination", targetDepth)) {
                    scheduledInstancesNetworkInterface.deleteOnTermination(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Description", targetDepth)) {
                    scheduledInstancesNetworkInterface.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DeviceIndex", targetDepth)) {
                    scheduledInstancesNetworkInterface.deviceIndex(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Group", targetDepth)) {
                    groups = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("Group/SecurityGroupId", targetDepth)) {
                    groups.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Ipv6AddressCount", targetDepth)) {
                    scheduledInstancesNetworkInterface.ipv6AddressCount(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Ipv6Address", targetDepth)) {
                    ipv6Addresses = new ArrayList<ScheduledInstancesIpv6Address>();
                    continue;
                }

                if (context.testExpression("Ipv6Address/Ipv6Address", targetDepth)) {
                    ipv6Addresses.add(ScheduledInstancesIpv6AddressUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NetworkInterfaceId", targetDepth)) {
                    scheduledInstancesNetworkInterface.networkInterfaceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PrivateIpAddress", targetDepth)) {
                    scheduledInstancesNetworkInterface.privateIpAddress(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("PrivateIpAddressConfig", targetDepth)) {
                    privateIpAddressConfigs = new ArrayList<ScheduledInstancesPrivateIpAddressConfig>();
                    continue;
                }

                if (context.testExpression("PrivateIpAddressConfig/PrivateIpAddressConfigSet", targetDepth)) {
                    privateIpAddressConfigs.add(ScheduledInstancesPrivateIpAddressConfigUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("SecondaryPrivateIpAddressCount", targetDepth)) {
                    scheduledInstancesNetworkInterface.secondaryPrivateIpAddressCount(IntegerUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("SubnetId", targetDepth)) {
                    scheduledInstancesNetworkInterface.subnetId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    scheduledInstancesNetworkInterface.groups(groups);
                    scheduledInstancesNetworkInterface.ipv6Addresses(ipv6Addresses);
                    scheduledInstancesNetworkInterface.privateIpAddressConfigs(privateIpAddressConfigs);
                    break;
                }
            }
        }
        return scheduledInstancesNetworkInterface.build();
    }

    private static final ScheduledInstancesNetworkInterfaceUnmarshaller INSTANCE = new ScheduledInstancesNetworkInterfaceUnmarshaller();

    public static ScheduledInstancesNetworkInterfaceUnmarshaller getInstance() {
        return INSTANCE;
    }
}
