/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.IdempotentUtils;

/**
 * RunScheduledInstancesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RunScheduledInstancesRequestMarshaller implements
        Marshaller<Request<RunScheduledInstancesRequest>, RunScheduledInstancesRequest> {

    public Request<RunScheduledInstancesRequest> marshall(RunScheduledInstancesRequest runScheduledInstancesRequest) {

        if (runScheduledInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<RunScheduledInstancesRequest> request = new DefaultRequest<RunScheduledInstancesRequest>(
                runScheduledInstancesRequest, "EC2Client");
        request.addParameter("Action", "RunScheduledInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        request.addParameter("ClientToken", IdempotentUtils.resolveString(runScheduledInstancesRequest.clientToken()));

        if (runScheduledInstancesRequest.instanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger(runScheduledInstancesRequest.instanceCount()));
        }

        ScheduledInstancesLaunchSpecification launchSpecification = runScheduledInstancesRequest.launchSpecification();
        if (launchSpecification != null) {

            java.util.List<ScheduledInstancesBlockDeviceMapping> scheduledInstancesLaunchSpecificationBlockDeviceMappingsList = launchSpecification
                    .blockDeviceMappings();
            if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsList != null) {
                int blockDeviceMappingsListIndex = 1;

                for (ScheduledInstancesBlockDeviceMapping scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue : scheduledInstancesLaunchSpecificationBlockDeviceMappingsList) {

                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.deviceName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                + ".DeviceName", StringUtils
                                .fromString(scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.deviceName()));
                    }

                    ScheduledInstancesEbs ebs = scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.ebs();
                    if (ebs != null) {

                        if (ebs.deleteOnTermination() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                    + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebs.deleteOnTermination()));
                        }

                        if (ebs.encrypted() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                    + ".Ebs.Encrypted", StringUtils.fromBoolean(ebs.encrypted()));
                        }

                        if (ebs.iops() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                    + ".Ebs.Iops", StringUtils.fromInteger(ebs.iops()));
                        }

                        if (ebs.snapshotId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                    + ".Ebs.SnapshotId", StringUtils.fromString(ebs.snapshotId()));
                        }

                        if (ebs.volumeSize() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                    + ".Ebs.VolumeSize", StringUtils.fromInteger(ebs.volumeSize()));
                        }

                        if (ebs.volumeType() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                    + ".Ebs.VolumeType", StringUtils.fromString(ebs.volumeType()));
                        }
                    }

                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.noDevice() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                + ".NoDevice", StringUtils
                                .fromString(scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.noDevice()));
                    }

                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.virtualName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex
                                + ".VirtualName", StringUtils
                                .fromString(scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.virtualName()));
                    }
                    blockDeviceMappingsListIndex++;
                }
            }

            if (launchSpecification.ebsOptimized() != null) {
                request.addParameter("LaunchSpecification.EbsOptimized",
                        StringUtils.fromBoolean(launchSpecification.ebsOptimized()));
            }

            ScheduledInstancesIamInstanceProfile iamInstanceProfile = launchSpecification.iamInstanceProfile();
            if (iamInstanceProfile != null) {

                if (iamInstanceProfile.arn() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Arn",
                            StringUtils.fromString(iamInstanceProfile.arn()));
                }

                if (iamInstanceProfile.name() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Name",
                            StringUtils.fromString(iamInstanceProfile.name()));
                }
            }

            if (launchSpecification.imageId() != null) {
                request.addParameter("LaunchSpecification.ImageId", StringUtils.fromString(launchSpecification.imageId()));
            }

            if (launchSpecification.instanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType",
                        StringUtils.fromString(launchSpecification.instanceType()));
            }

            if (launchSpecification.kernelId() != null) {
                request.addParameter("LaunchSpecification.KernelId", StringUtils.fromString(launchSpecification.kernelId()));
            }

            if (launchSpecification.keyName() != null) {
                request.addParameter("LaunchSpecification.KeyName", StringUtils.fromString(launchSpecification.keyName()));
            }

            ScheduledInstancesMonitoring monitoring = launchSpecification.monitoring();
            if (monitoring != null) {

                if (monitoring.enabled() != null) {
                    request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean(monitoring.enabled()));
                }
            }

            java.util.List<ScheduledInstancesNetworkInterface> scheduledInstancesLaunchSpecificationNetworkInterfacesList = launchSpecification
                    .networkInterfaces();
            if (scheduledInstancesLaunchSpecificationNetworkInterfacesList != null) {
                int networkInterfacesListIndex = 1;

                for (ScheduledInstancesNetworkInterface scheduledInstancesLaunchSpecificationNetworkInterfacesListValue : scheduledInstancesLaunchSpecificationNetworkInterfacesList) {

                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.associatePublicIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".AssociatePublicIpAddress", StringUtils
                                .fromBoolean(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue
                                        .associatePublicIpAddress()));
                    }

                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.deleteOnTermination() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".DeleteOnTermination", StringUtils
                                .fromBoolean(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue
                                        .deleteOnTermination()));
                    }

                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.description() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".Description", StringUtils
                                .fromString(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.description()));
                    }

                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.deviceIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".DeviceIndex", StringUtils
                                .fromInteger(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.deviceIndex()));
                    }

                    java.util.List<String> scheduledInstancesNetworkInterfaceGroupsList = scheduledInstancesLaunchSpecificationNetworkInterfacesListValue
                            .groups();
                    if (scheduledInstancesNetworkInterfaceGroupsList != null) {
                        int groupsListIndex = 1;

                        for (String scheduledInstancesNetworkInterfaceGroupsListValue : scheduledInstancesNetworkInterfaceGroupsList) {
                            if (scheduledInstancesNetworkInterfaceGroupsListValue != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                        + ".Group." + groupsListIndex,
                                        StringUtils.fromString(scheduledInstancesNetworkInterfaceGroupsListValue));
                            }
                            groupsListIndex++;
                        }
                    }

                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.ipv6AddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".Ipv6AddressCount", StringUtils
                                .fromInteger(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.ipv6AddressCount()));
                    }

                    java.util.List<ScheduledInstancesIpv6Address> scheduledInstancesNetworkInterfaceIpv6AddressesList = scheduledInstancesLaunchSpecificationNetworkInterfacesListValue
                            .ipv6Addresses();
                    if (scheduledInstancesNetworkInterfaceIpv6AddressesList != null) {
                        int ipv6AddressesListIndex = 1;

                        for (ScheduledInstancesIpv6Address scheduledInstancesNetworkInterfaceIpv6AddressesListValue : scheduledInstancesNetworkInterfaceIpv6AddressesList) {

                            if (scheduledInstancesNetworkInterfaceIpv6AddressesListValue.ipv6Address() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                        + ".Ipv6Address." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils
                                        .fromString(scheduledInstancesNetworkInterfaceIpv6AddressesListValue.ipv6Address()));
                            }
                            ipv6AddressesListIndex++;
                        }
                    }

                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.networkInterfaceId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".NetworkInterfaceId", StringUtils
                                .fromString(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.networkInterfaceId()));
                    }

                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.privateIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".PrivateIpAddress", StringUtils
                                .fromString(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.privateIpAddress()));
                    }

                    java.util.List<ScheduledInstancesPrivateIpAddressConfig> scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList = scheduledInstancesLaunchSpecificationNetworkInterfacesListValue
                            .privateIpAddressConfigs();
                    if (scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList != null) {
                        int privateIpAddressConfigsListIndex = 1;

                        for (ScheduledInstancesPrivateIpAddressConfig scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue : scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList) {

                            if (scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.primary() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                        + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".Primary",
                                        StringUtils
                                                .fromBoolean(scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue
                                                        .primary()));
                            }

                            if (scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.privateIpAddress() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                        + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".PrivateIpAddress",
                                        StringUtils.fromString(scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue
                                                .privateIpAddress()));
                            }
                            privateIpAddressConfigsListIndex++;
                        }
                    }

                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex
                                + ".SecondaryPrivateIpAddressCount", StringUtils
                                .fromInteger(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue
                                        .secondaryPrivateIpAddressCount()));
                    }

                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.subnetId() != null) {
                        request.addParameter(
                                "LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SubnetId",
                                StringUtils.fromString(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.subnetId()));
                    }
                    networkInterfacesListIndex++;
                }
            }

            ScheduledInstancesPlacement placement = launchSpecification.placement();
            if (placement != null) {

                if (placement.availabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone",
                            StringUtils.fromString(placement.availabilityZone()));
                }

                if (placement.groupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString(placement.groupName()));
                }
            }

            if (launchSpecification.ramdiskId() != null) {
                request.addParameter("LaunchSpecification.RamdiskId", StringUtils.fromString(launchSpecification.ramdiskId()));
            }

            java.util.List<String> scheduledInstancesLaunchSpecificationSecurityGroupIdsList = launchSpecification
                    .securityGroupIds();
            if (scheduledInstancesLaunchSpecificationSecurityGroupIdsList != null) {
                int securityGroupIdsListIndex = 1;

                for (String scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue : scheduledInstancesLaunchSpecificationSecurityGroupIdsList) {
                    if (scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue != null) {
                        request.addParameter("LaunchSpecification.SecurityGroupId." + securityGroupIdsListIndex,
                                StringUtils.fromString(scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue));
                    }
                    securityGroupIdsListIndex++;
                }
            }

            if (launchSpecification.subnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString(launchSpecification.subnetId()));
            }

            if (launchSpecification.userData() != null) {
                request.addParameter("LaunchSpecification.UserData", StringUtils.fromString(launchSpecification.userData()));
            }
        }

        if (runScheduledInstancesRequest.scheduledInstanceId() != null) {
            request.addParameter("ScheduledInstanceId",
                    StringUtils.fromString(runScheduledInstancesRequest.scheduledInstanceId()));
        }

        return request;
    }

}
