/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * GetHostReservationPurchasePreviewRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetHostReservationPurchasePreviewRequestMarshaller implements
        Marshaller<Request<GetHostReservationPurchasePreviewRequest>, GetHostReservationPurchasePreviewRequest> {

    public Request<GetHostReservationPurchasePreviewRequest> marshall(
            GetHostReservationPurchasePreviewRequest getHostReservationPurchasePreviewRequest) {

        if (getHostReservationPurchasePreviewRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<GetHostReservationPurchasePreviewRequest> request = new DefaultRequest<GetHostReservationPurchasePreviewRequest>(
                getHostReservationPurchasePreviewRequest, "EC2Client");
        request.addParameter("Action", "GetHostReservationPurchasePreview");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> getHostReservationPurchasePreviewRequestHostIdSetList = getHostReservationPurchasePreviewRequest
                .hostIdSet();
        if (getHostReservationPurchasePreviewRequestHostIdSetList != null) {
            int hostIdSetListIndex = 1;

            for (String getHostReservationPurchasePreviewRequestHostIdSetListValue : getHostReservationPurchasePreviewRequestHostIdSetList) {
                if (getHostReservationPurchasePreviewRequestHostIdSetListValue != null) {
                    request.addParameter("HostIdSet." + hostIdSetListIndex,
                            StringUtils.fromString(getHostReservationPurchasePreviewRequestHostIdSetListValue));
                }
                hostIdSetListIndex++;
            }
        }

        if (getHostReservationPurchasePreviewRequest.offeringId() != null) {
            request.addParameter("OfferingId", StringUtils.fromString(getHostReservationPurchasePreviewRequest.offeringId()));
        }

        return request;
    }

}
