/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * CancelSpotFleetRequestsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CancelSpotFleetRequestsResponseUnmarshaller implements
        Unmarshaller<CancelSpotFleetRequestsResponse, StaxUnmarshallerContext> {

    public CancelSpotFleetRequestsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        CancelSpotFleetRequestsResponse.Builder cancelSpotFleetRequestsResponse = CancelSpotFleetRequestsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests = null;
        java.util.List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                cancelSpotFleetRequestsResponse.successfulFleetRequests(successfulFleetRequests);
                cancelSpotFleetRequestsResponse.unsuccessfulFleetRequests(unsuccessfulFleetRequests);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("successfulFleetRequestSet", targetDepth)) {
                    successfulFleetRequests = new ArrayList<CancelSpotFleetRequestsSuccessItem>();
                    continue;
                }

                if (context.testExpression("successfulFleetRequestSet/item", targetDepth)) {
                    successfulFleetRequests.add(CancelSpotFleetRequestsSuccessItemUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("unsuccessfulFleetRequestSet", targetDepth)) {
                    unsuccessfulFleetRequests = new ArrayList<CancelSpotFleetRequestsErrorItem>();
                    continue;
                }

                if (context.testExpression("unsuccessfulFleetRequestSet/item", targetDepth)) {
                    unsuccessfulFleetRequests.add(CancelSpotFleetRequestsErrorItemUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    cancelSpotFleetRequestsResponse.successfulFleetRequests(successfulFleetRequests);
                    cancelSpotFleetRequestsResponse.unsuccessfulFleetRequests(unsuccessfulFleetRequests);
                    break;
                }
            }
        }
        return cancelSpotFleetRequestsResponse.build();
    }

    private static final CancelSpotFleetRequestsResponseUnmarshaller INSTANCE = new CancelSpotFleetRequestsResponseUnmarshaller();

    public static CancelSpotFleetRequestsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
