/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * AssociateAddressRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AssociateAddressRequestMarshaller implements Marshaller<Request<AssociateAddressRequest>, AssociateAddressRequest> {

    public Request<AssociateAddressRequest> marshall(AssociateAddressRequest associateAddressRequest) {

        if (associateAddressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<AssociateAddressRequest> request = new DefaultRequest<AssociateAddressRequest>(associateAddressRequest,
                "EC2Client");
        request.addParameter("Action", "AssociateAddress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (associateAddressRequest.allocationId() != null) {
            request.addParameter("AllocationId", StringUtils.fromString(associateAddressRequest.allocationId()));
        }

        if (associateAddressRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(associateAddressRequest.instanceId()));
        }

        if (associateAddressRequest.publicIp() != null) {
            request.addParameter("PublicIp", StringUtils.fromString(associateAddressRequest.publicIp()));
        }

        if (associateAddressRequest.allowReassociation() != null) {
            request.addParameter("AllowReassociation", StringUtils.fromBoolean(associateAddressRequest.allowReassociation()));
        }

        if (associateAddressRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(associateAddressRequest.networkInterfaceId()));
        }

        if (associateAddressRequest.privateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString(associateAddressRequest.privateIpAddress()));
        }

        return request;
    }

}
