/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the launch specification for a Scheduled Instance.
 * </p>
 * <p>
 * If you are launching the Scheduled Instance in EC2-VPC, you must specify the ID of the subnet. You can specify the
 * subnet using either <code>SubnetId</code> or <code>NetworkInterface</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduledInstancesLaunchSpecification implements
        ToCopyableBuilder<ScheduledInstancesLaunchSpecification.Builder, ScheduledInstancesLaunchSpecification> {
    private final List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings;

    private final Boolean ebsOptimized;

    private final ScheduledInstancesIamInstanceProfile iamInstanceProfile;

    private final String imageId;

    private final String instanceType;

    private final String kernelId;

    private final String keyName;

    private final ScheduledInstancesMonitoring monitoring;

    private final List<ScheduledInstancesNetworkInterface> networkInterfaces;

    private final ScheduledInstancesPlacement placement;

    private final String ramdiskId;

    private final List<String> securityGroupIds;

    private final String subnetId;

    private final String userData;

    private ScheduledInstancesLaunchSpecification(BuilderImpl builder) {
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
    }

    /**
     * <p>
     * One or more block device mapping entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more block device mapping entries.
     */
    public List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to
     * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't
     * available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated
     *         throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
     *         This optimization isn't available with all instance types. Additional usage charges apply when using an
     *         EBS-optimized instance.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The IAM instance profile.
     * </p>
     * 
     * @return The IAM instance profile.
     */
    public ScheduledInstancesIamInstanceProfile iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI).
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI).
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * 
     * @return The instance type.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * 
     * @return The ID of the kernel.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * 
     * @return The name of the key pair.
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * Enable or disable monitoring for the instances.
     * </p>
     * 
     * @return Enable or disable monitoring for the instances.
     */
    public ScheduledInstancesMonitoring monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * One or more network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more network interfaces.
     */
    public List<ScheduledInstancesNetworkInterface> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * The placement information.
     * </p>
     * 
     * @return The placement information.
     */
    public ScheduledInstancesPlacement placement() {
        return placement;
    }

    /**
     * <p>
     * The ID of the RAM disk.
     * </p>
     * 
     * @return The ID of the RAM disk.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The IDs of one or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of one or more security groups.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The ID of the subnet in which to launch the instances.
     * </p>
     * 
     * @return The ID of the subnet in which to launch the instances.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The base64-encoded MIME user data.
     * </p>
     * 
     * @return The base64-encoded MIME user data.
     */
    public String userData() {
        return userData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesLaunchSpecification)) {
            return false;
        }
        ScheduledInstancesLaunchSpecification other = (ScheduledInstancesLaunchSpecification) obj;
        return Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(kernelId(), other.kernelId())
                && Objects.equals(keyName(), other.keyName()) && Objects.equals(monitoring(), other.monitoring())
                && Objects.equals(networkInterfaces(), other.networkInterfaces())
                && Objects.equals(placement(), other.placement()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(userData(), other.userData());
    }

    @Override
    public String toString() {
        return ToString.builder("ScheduledInstancesLaunchSpecification").add("BlockDeviceMappings", blockDeviceMappings())
                .add("EbsOptimized", ebsOptimized()).add("IamInstanceProfile", iamInstanceProfile()).add("ImageId", imageId())
                .add("InstanceType", instanceType()).add("KernelId", kernelId()).add("KeyName", keyName())
                .add("Monitoring", monitoring()).add("NetworkInterfaces", networkInterfaces()).add("Placement", placement())
                .add("RamdiskId", ramdiskId()).add("SecurityGroupIds", securityGroupIds()).add("SubnetId", subnetId())
                .add("UserData", userData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockDeviceMappings":
            return Optional.of(clazz.cast(blockDeviceMappings()));
        case "EbsOptimized":
            return Optional.of(clazz.cast(ebsOptimized()));
        case "IamInstanceProfile":
            return Optional.of(clazz.cast(iamInstanceProfile()));
        case "ImageId":
            return Optional.of(clazz.cast(imageId()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceType()));
        case "KernelId":
            return Optional.of(clazz.cast(kernelId()));
        case "KeyName":
            return Optional.of(clazz.cast(keyName()));
        case "Monitoring":
            return Optional.of(clazz.cast(monitoring()));
        case "NetworkInterfaces":
            return Optional.of(clazz.cast(networkInterfaces()));
        case "Placement":
            return Optional.of(clazz.cast(placement()));
        case "RamdiskId":
            return Optional.of(clazz.cast(ramdiskId()));
        case "SecurityGroupIds":
            return Optional.of(clazz.cast(securityGroupIds()));
        case "SubnetId":
            return Optional.of(clazz.cast(subnetId()));
        case "UserData":
            return Optional.of(clazz.cast(userData()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduledInstancesLaunchSpecification> {
        /**
         * <p>
         * One or more block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * One or more block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(ScheduledInstancesBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to
         * Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization
         * isn't available with all instance types. Additional usage charges apply when using an EBS-optimized instance.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance.
         *        This optimization isn't available with all instance types. Additional usage charges apply when using
         *        an EBS-optimized instance.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(ScheduledInstancesIamInstanceProfile iamInstanceProfile);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduledInstancesIamInstanceProfile.Builder}
         * avoiding the need to create one manually via {@link ScheduledInstancesIamInstanceProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledInstancesIamInstanceProfile.Builder#build()} is called
         * immediately and its result is passed to {@link #iamInstanceProfile(ScheduledInstancesIamInstanceProfile)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link ScheduledInstancesIamInstanceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(ScheduledInstancesIamInstanceProfile)
         */
        default Builder iamInstanceProfile(Consumer<ScheduledInstancesIamInstanceProfile.Builder> iamInstanceProfile) {
            return iamInstanceProfile(ScheduledInstancesIamInstanceProfile.builder().apply(iamInstanceProfile).build());
        }

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI).
         * </p>
         * 
         * @param imageId
         *        The ID of the Amazon Machine Image (AMI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * Enable or disable monitoring for the instances.
         * </p>
         * 
         * @param monitoring
         *        Enable or disable monitoring for the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(ScheduledInstancesMonitoring monitoring);

        /**
         * <p>
         * Enable or disable monitoring for the instances.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduledInstancesMonitoring.Builder} avoiding
         * the need to create one manually via {@link ScheduledInstancesMonitoring#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledInstancesMonitoring.Builder#build()} is called
         * immediately and its result is passed to {@link #monitoring(ScheduledInstancesMonitoring)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link ScheduledInstancesMonitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(ScheduledInstancesMonitoring)
         */
        default Builder monitoring(Consumer<ScheduledInstancesMonitoring.Builder> monitoring) {
            return monitoring(ScheduledInstancesMonitoring.builder().apply(monitoring).build());
        }

        /**
         * <p>
         * One or more network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<ScheduledInstancesNetworkInterface> networkInterfaces);

        /**
         * <p>
         * One or more network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(ScheduledInstancesNetworkInterface... networkInterfaces);

        /**
         * <p>
         * The placement information.
         * </p>
         * 
         * @param placement
         *        The placement information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(ScheduledInstancesPlacement placement);

        /**
         * <p>
         * The placement information.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduledInstancesPlacement.Builder} avoiding
         * the need to create one manually via {@link ScheduledInstancesPlacement#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledInstancesPlacement.Builder#build()} is called
         * immediately and its result is passed to {@link #placement(ScheduledInstancesPlacement)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link ScheduledInstancesPlacement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(ScheduledInstancesPlacement)
         */
        default Builder placement(Consumer<ScheduledInstancesPlacement.Builder> placement) {
            return placement(ScheduledInstancesPlacement.builder().apply(placement).build());
        }

        /**
         * <p>
         * The ID of the RAM disk.
         * </p>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The ID of the subnet in which to launch the instances.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in which to launch the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The base64-encoded MIME user data.
         * </p>
         * 
         * @param userData
         *        The base64-encoded MIME user data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);
    }

    static final class BuilderImpl implements Builder {
        private List<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings;

        private Boolean ebsOptimized;

        private ScheduledInstancesIamInstanceProfile iamInstanceProfile;

        private String imageId;

        private String instanceType;

        private String kernelId;

        private String keyName;

        private ScheduledInstancesMonitoring monitoring;

        private List<ScheduledInstancesNetworkInterface> networkInterfaces;

        private ScheduledInstancesPlacement placement;

        private String ramdiskId;

        private List<String> securityGroupIds;

        private String subnetId;

        private String userData;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesLaunchSpecification model) {
            blockDeviceMappings(model.blockDeviceMappings);
            ebsOptimized(model.ebsOptimized);
            iamInstanceProfile(model.iamInstanceProfile);
            imageId(model.imageId);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            keyName(model.keyName);
            monitoring(model.monitoring);
            networkInterfaces(model.networkInterfaces);
            placement(model.placement);
            ramdiskId(model.ramdiskId);
            securityGroupIds(model.securityGroupIds);
            subnetId(model.subnetId);
            userData(model.userData);
        }

        public final Collection<ScheduledInstancesBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream()
                    .map(ScheduledInstancesBlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = ScheduledInstancesBlockDeviceMappingSetCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(ScheduledInstancesBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<ScheduledInstancesBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = ScheduledInstancesBlockDeviceMappingSetCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final ScheduledInstancesIamInstanceProfile.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(ScheduledInstancesIamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(ScheduledInstancesIamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final ScheduledInstancesMonitoring.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(ScheduledInstancesMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(ScheduledInstancesMonitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public final Collection<ScheduledInstancesNetworkInterface.Builder> getNetworkInterfaces() {
            return networkInterfaces != null ? networkInterfaces.stream().map(ScheduledInstancesNetworkInterface::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<ScheduledInstancesNetworkInterface> networkInterfaces) {
            this.networkInterfaces = ScheduledInstancesNetworkInterfaceSetCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(ScheduledInstancesNetworkInterface... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<ScheduledInstancesNetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = ScheduledInstancesNetworkInterfaceSetCopier.copyFromBuilder(networkInterfaces);
        }

        public final ScheduledInstancesPlacement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(ScheduledInstancesPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(ScheduledInstancesPlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ScheduledInstancesSecurityGroupIdSetCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ScheduledInstancesSecurityGroupIdSetCopier.copy(securityGroupIds);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public ScheduledInstancesLaunchSpecification build() {
            return new ScheduledInstancesLaunchSpecification(this);
        }
    }
}
