/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the storage parameters for S3 and S3 buckets for an instance store-backed AMI.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class S3Storage implements ToCopyableBuilder<S3Storage.Builder, S3Storage> {
    private final String awsAccessKeyId;

    private final String bucket;

    private final String prefix;

    private final String uploadPolicy;

    private final String uploadPolicySignature;

    private S3Storage(BuilderImpl builder) {
        this.awsAccessKeyId = builder.awsAccessKeyId;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
        this.uploadPolicy = builder.uploadPolicy;
        this.uploadPolicySignature = builder.uploadPolicySignature;
    }

    /**
     * <p>
     * The access key ID of the owner of the bucket. Before you specify a value for your access key ID, review and
     * follow the guidance in <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">Best Practices for
     * Managing AWS Access Keys</a>.
     * </p>
     * 
     * @return The access key ID of the owner of the bucket. Before you specify a value for your access key ID, review
     *         and follow the guidance in <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">Best Practices
     *         for Managing AWS Access Keys</a>.
     */
    public String awsAccessKeyId() {
        return awsAccessKeyId;
    }

    /**
     * <p>
     * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon
     * EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
     * </p>
     * 
     * @return The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that
     *         Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2
     *         returns an error.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The beginning of the file name of the AMI.
     * </p>
     * 
     * @return The beginning of the file name of the AMI.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your behalf.
     * </p>
     * 
     * @return An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your
     *         behalf.
     */
    public String uploadPolicy() {
        return uploadPolicy;
    }

    /**
     * <p>
     * The signature of the JSON document.
     * </p>
     * 
     * @return The signature of the JSON document.
     */
    public String uploadPolicySignature() {
        return uploadPolicySignature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(uploadPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(uploadPolicySignature());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Storage)) {
            return false;
        }
        S3Storage other = (S3Storage) obj;
        return Objects.equals(awsAccessKeyId(), other.awsAccessKeyId()) && Objects.equals(bucket(), other.bucket())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(uploadPolicy(), other.uploadPolicy())
                && Objects.equals(uploadPolicySignature(), other.uploadPolicySignature());
    }

    @Override
    public String toString() {
        return ToString.builder("S3Storage").add("AWSAccessKeyId", awsAccessKeyId()).add("Bucket", bucket())
                .add("Prefix", prefix()).add("UploadPolicy", uploadPolicy())
                .add("UploadPolicySignature", uploadPolicySignature()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AWSAccessKeyId":
            return Optional.of(clazz.cast(awsAccessKeyId()));
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "Prefix":
            return Optional.of(clazz.cast(prefix()));
        case "UploadPolicy":
            return Optional.of(clazz.cast(uploadPolicy()));
        case "UploadPolicySignature":
            return Optional.of(clazz.cast(uploadPolicySignature()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, S3Storage> {
        /**
         * <p>
         * The access key ID of the owner of the bucket. Before you specify a value for your access key ID, review and
         * follow the guidance in <a
         * href="http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">Best Practices for
         * Managing AWS Access Keys</a>.
         * </p>
         * 
         * @param awsAccessKeyId
         *        The access key ID of the owner of the bucket. Before you specify a value for your access key ID,
         *        review and follow the guidance in <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html">Best Practices
         *        for Managing AWS Access Keys</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccessKeyId(String awsAccessKeyId);

        /**
         * <p>
         * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that
         * Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns
         * an error.
         * </p>
         * 
         * @param bucket
         *        The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket
         *        that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon
         *        EC2 returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The beginning of the file name of the AMI.
         * </p>
         * 
         * @param prefix
         *        The beginning of the file name of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your behalf.
         * </p>
         * 
         * @param uploadPolicy
         *        An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your
         *        behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadPolicy(String uploadPolicy);

        /**
         * <p>
         * The signature of the JSON document.
         * </p>
         * 
         * @param uploadPolicySignature
         *        The signature of the JSON document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadPolicySignature(String uploadPolicySignature);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccessKeyId;

        private String bucket;

        private String prefix;

        private String uploadPolicy;

        private String uploadPolicySignature;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Storage model) {
            awsAccessKeyId(model.awsAccessKeyId);
            bucket(model.bucket);
            prefix(model.prefix);
            uploadPolicy(model.uploadPolicy);
            uploadPolicySignature(model.uploadPolicySignature);
        }

        public final String getAWSAccessKeyId() {
            return awsAccessKeyId;
        }

        @Override
        public final Builder awsAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
            return this;
        }

        public final void setAWSAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getUploadPolicy() {
            return uploadPolicy;
        }

        @Override
        public final Builder uploadPolicy(String uploadPolicy) {
            this.uploadPolicy = uploadPolicy;
            return this;
        }

        public final void setUploadPolicy(String uploadPolicy) {
            this.uploadPolicy = uploadPolicy;
        }

        public final String getUploadPolicySignature() {
            return uploadPolicySignature;
        }

        @Override
        public final Builder uploadPolicySignature(String uploadPolicySignature) {
            this.uploadPolicySignature = uploadPolicySignature;
            return this;
        }

        public final void setUploadPolicySignature(String uploadPolicySignature) {
            this.uploadPolicySignature = uploadPolicySignature;
        }

        @Override
        public S3Storage build() {
            return new S3Storage(this);
        }
    }
}
