/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an association between a route table and a subnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RouteTableAssociation implements ToCopyableBuilder<RouteTableAssociation.Builder, RouteTableAssociation> {
    private final Boolean main;

    private final String routeTableAssociationId;

    private final String routeTableId;

    private final String subnetId;

    private RouteTableAssociation(BuilderImpl builder) {
        this.main = builder.main;
        this.routeTableAssociationId = builder.routeTableAssociationId;
        this.routeTableId = builder.routeTableId;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * Indicates whether this is the main route table.
     * </p>
     * 
     * @return Indicates whether this is the main route table.
     */
    public Boolean main() {
        return main;
    }

    /**
     * <p>
     * The ID of the association between a route table and a subnet.
     * </p>
     * 
     * @return The ID of the association between a route table and a subnet.
     */
    public String routeTableAssociationId() {
        return routeTableAssociationId;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public String routeTableId() {
        return routeTableId;
    }

    /**
     * <p>
     * The ID of the subnet. A subnet ID is not returned for an implicit association.
     * </p>
     * 
     * @return The ID of the subnet. A subnet ID is not returned for an implicit association.
     */
    public String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(main());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTableAssociation)) {
            return false;
        }
        RouteTableAssociation other = (RouteTableAssociation) obj;
        return Objects.equals(main(), other.main()) && Objects.equals(routeTableAssociationId(), other.routeTableAssociationId())
                && Objects.equals(routeTableId(), other.routeTableId()) && Objects.equals(subnetId(), other.subnetId());
    }

    @Override
    public String toString() {
        return ToString.builder("RouteTableAssociation").add("Main", main())
                .add("RouteTableAssociationId", routeTableAssociationId()).add("RouteTableId", routeTableId())
                .add("SubnetId", subnetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Main":
            return Optional.of(clazz.cast(main()));
        case "RouteTableAssociationId":
            return Optional.of(clazz.cast(routeTableAssociationId()));
        case "RouteTableId":
            return Optional.of(clazz.cast(routeTableId()));
        case "SubnetId":
            return Optional.of(clazz.cast(subnetId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RouteTableAssociation> {
        /**
         * <p>
         * Indicates whether this is the main route table.
         * </p>
         * 
         * @param main
         *        Indicates whether this is the main route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder main(Boolean main);

        /**
         * <p>
         * The ID of the association between a route table and a subnet.
         * </p>
         * 
         * @param routeTableAssociationId
         *        The ID of the association between a route table and a subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableAssociationId(String routeTableAssociationId);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * The ID of the subnet. A subnet ID is not returned for an implicit association.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet. A subnet ID is not returned for an implicit association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);
    }

    static final class BuilderImpl implements Builder {
        private Boolean main;

        private String routeTableAssociationId;

        private String routeTableId;

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTableAssociation model) {
            main(model.main);
            routeTableAssociationId(model.routeTableAssociationId);
            routeTableId(model.routeTableId);
            subnetId(model.subnetId);
        }

        public final Boolean getMain() {
            return main;
        }

        @Override
        public final Builder main(Boolean main) {
            this.main = main;
            return this;
        }

        public final void setMain(Boolean main) {
            this.main = main;
        }

        public final String getRouteTableAssociationId() {
            return routeTableAssociationId;
        }

        @Override
        public final Builder routeTableAssociationId(String routeTableAssociationId) {
            this.routeTableAssociationId = routeTableAssociationId;
            return this;
        }

        public final void setRouteTableAssociationId(String routeTableAssociationId) {
            this.routeTableAssociationId = routeTableAssociationId;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public RouteTableAssociation build() {
            return new RouteTableAssociation(this);
        }
    }
}
