/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ResetFpgaImageAttributeRequest extends EC2Request implements
        ToCopyableBuilder<ResetFpgaImageAttributeRequest.Builder, ResetFpgaImageAttributeRequest> {
    private final String fpgaImageId;

    private final String attribute;

    private ResetFpgaImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.fpgaImageId = builder.fpgaImageId;
        this.attribute = builder.attribute;
    }

    /**
     * <p>
     * The ID of the AFI.
     * </p>
     * 
     * @return The ID of the AFI.
     */
    public String fpgaImageId() {
        return fpgaImageId;
    }

    /**
     * <p>
     * The attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link ResetFpgaImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeString}.
     * </p>
     * 
     * @return The attribute.
     * @see ResetFpgaImageAttributeName
     */
    public ResetFpgaImageAttributeName attribute() {
        return ResetFpgaImageAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link ResetFpgaImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeString}.
     * </p>
     * 
     * @return The attribute.
     * @see ResetFpgaImageAttributeName
     */
    public String attributeString() {
        return attribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(attributeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetFpgaImageAttributeRequest)) {
            return false;
        }
        ResetFpgaImageAttributeRequest other = (ResetFpgaImageAttributeRequest) obj;
        return Objects.equals(fpgaImageId(), other.fpgaImageId()) && Objects.equals(attributeString(), other.attributeString());
    }

    @Override
    public String toString() {
        return ToString.builder("ResetFpgaImageAttributeRequest").add("FpgaImageId", fpgaImageId())
                .add("Attribute", attributeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageId":
            return Optional.of(clazz.cast(fpgaImageId()));
        case "Attribute":
            return Optional.of(clazz.cast(attributeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ResetFpgaImageAttributeRequest> {
        /**
         * <p>
         * The ID of the AFI.
         * </p>
         * 
         * @param fpgaImageId
         *        The ID of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageId(String fpgaImageId);

        /**
         * <p>
         * The attribute.
         * </p>
         * 
         * @param attribute
         *        The attribute.
         * @see ResetFpgaImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResetFpgaImageAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute.
         * </p>
         * 
         * @param attribute
         *        The attribute.
         * @see ResetFpgaImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResetFpgaImageAttributeName
         */
        Builder attribute(ResetFpgaImageAttributeName attribute);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String fpgaImageId;

        private String attribute;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetFpgaImageAttributeRequest model) {
            fpgaImageId(model.fpgaImageId);
            attribute(model.attribute);
        }

        public final String getFpgaImageId() {
            return fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ResetFpgaImageAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ResetFpgaImageAttributeRequest build() {
            return new ResetFpgaImageAttributeRequest(this);
        }
    }
}
