/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of RequestSpotInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RequestSpotInstancesResponse extends EC2Response implements
        ToCopyableBuilder<RequestSpotInstancesResponse.Builder, RequestSpotInstancesResponse> {
    private final List<SpotInstanceRequest> spotInstanceRequests;

    private RequestSpotInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.spotInstanceRequests = builder.spotInstanceRequests;
    }

    /**
     * <p>
     * One or more Spot instance requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Spot instance requests.
     */
    public List<SpotInstanceRequest> spotInstanceRequests() {
        return spotInstanceRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spotInstanceRequests());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotInstancesResponse)) {
            return false;
        }
        RequestSpotInstancesResponse other = (RequestSpotInstancesResponse) obj;
        return Objects.equals(spotInstanceRequests(), other.spotInstanceRequests());
    }

    @Override
    public String toString() {
        return ToString.builder("RequestSpotInstancesResponse").add("SpotInstanceRequests", spotInstanceRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotInstanceRequests":
            return Optional.of(clazz.cast(spotInstanceRequests()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, RequestSpotInstancesResponse> {
        /**
         * <p>
         * One or more Spot instance requests.
         * </p>
         * 
         * @param spotInstanceRequests
         *        One or more Spot instance requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequests(Collection<SpotInstanceRequest> spotInstanceRequests);

        /**
         * <p>
         * One or more Spot instance requests.
         * </p>
         * 
         * @param spotInstanceRequests
         *        One or more Spot instance requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequests(SpotInstanceRequest... spotInstanceRequests);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<SpotInstanceRequest> spotInstanceRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotInstancesResponse model) {
            spotInstanceRequests(model.spotInstanceRequests);
        }

        public final Collection<SpotInstanceRequest.Builder> getSpotInstanceRequests() {
            return spotInstanceRequests != null ? spotInstanceRequests.stream().map(SpotInstanceRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder spotInstanceRequests(Collection<SpotInstanceRequest> spotInstanceRequests) {
            this.spotInstanceRequests = SpotInstanceRequestListCopier.copy(spotInstanceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequests(SpotInstanceRequest... spotInstanceRequests) {
            spotInstanceRequests(Arrays.asList(spotInstanceRequests));
            return this;
        }

        public final void setSpotInstanceRequests(Collection<SpotInstanceRequest.BuilderImpl> spotInstanceRequests) {
            this.spotInstanceRequests = SpotInstanceRequestListCopier.copyFromBuilder(spotInstanceRequests);
        }

        @Override
        public RequestSpotInstancesResponse build() {
            return new RequestSpotInstancesResponse(this);
        }
    }
}
