/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of RejectVpcPeeringConnection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RejectVpcPeeringConnectionResponse extends EC2Response implements
        ToCopyableBuilder<RejectVpcPeeringConnectionResponse.Builder, RejectVpcPeeringConnectionResponse> {
    private final Boolean returnValue;

    private RejectVpcPeeringConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
    }

    /**
     * <p>
     * Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
     * </p>
     * 
     * @return Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
     */
    public Boolean returnValue() {
        return returnValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(returnValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectVpcPeeringConnectionResponse)) {
            return false;
        }
        RejectVpcPeeringConnectionResponse other = (RejectVpcPeeringConnectionResponse) obj;
        return Objects.equals(returnValue(), other.returnValue());
    }

    @Override
    public String toString() {
        return ToString.builder("RejectVpcPeeringConnectionResponse").add("ReturnValue", returnValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReturnValue":
            return Optional.of(clazz.cast(returnValue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, RejectVpcPeeringConnectionResponse> {
        /**
         * <p>
         * Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
         * </p>
         * 
         * @param returnValue
         *        Returns <code>true</code> if the request succeeds; otherwise, it returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnValue(Boolean returnValue);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private Boolean returnValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectVpcPeeringConnectionResponse model) {
            returnValue(model.returnValue);
        }

        public final Boolean getReturnValue() {
            return returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public RejectVpcPeeringConnectionResponse build() {
            return new RejectVpcPeeringConnectionResponse(this);
        }
    }
}
