/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for PurchaseReservedInstancesOffering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PurchaseReservedInstancesOfferingRequest extends EC2Request implements
        ToCopyableBuilder<PurchaseReservedInstancesOfferingRequest.Builder, PurchaseReservedInstancesOfferingRequest> {
    private final Integer instanceCount;

    private final String reservedInstancesOfferingId;

    private final ReservedInstanceLimitPrice limitPrice;

    private PurchaseReservedInstancesOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.instanceCount = builder.instanceCount;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.limitPrice = builder.limitPrice;
    }

    /**
     * <p>
     * The number of Reserved Instances to purchase.
     * </p>
     * 
     * @return The number of Reserved Instances to purchase.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The ID of the Reserved Instance offering to purchase.
     * </p>
     * 
     * @return The ID of the Reserved Instance offering to purchase.
     */
    public String reservedInstancesOfferingId() {
        return reservedInstancesOfferingId;
    }

    /**
     * <p>
     * Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved
     * Instances are not purchased at unexpected prices.
     * </p>
     * 
     * @return Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the
     *         Reserved Instances are not purchased at unexpected prices.
     */
    public ReservedInstanceLimitPrice limitPrice() {
        return limitPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(limitPrice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedInstancesOfferingRequest)) {
            return false;
        }
        PurchaseReservedInstancesOfferingRequest other = (PurchaseReservedInstancesOfferingRequest) obj;
        return Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(reservedInstancesOfferingId(), other.reservedInstancesOfferingId())
                && Objects.equals(limitPrice(), other.limitPrice());
    }

    @Override
    public String toString() {
        return ToString.builder("PurchaseReservedInstancesOfferingRequest").add("InstanceCount", instanceCount())
                .add("ReservedInstancesOfferingId", reservedInstancesOfferingId()).add("LimitPrice", limitPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceCount":
            return Optional.of(clazz.cast(instanceCount()));
        case "ReservedInstancesOfferingId":
            return Optional.of(clazz.cast(reservedInstancesOfferingId()));
        case "LimitPrice":
            return Optional.of(clazz.cast(limitPrice()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, PurchaseReservedInstancesOfferingRequest> {
        /**
         * <p>
         * The number of Reserved Instances to purchase.
         * </p>
         * 
         * @param instanceCount
         *        The number of Reserved Instances to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The ID of the Reserved Instance offering to purchase.
         * </p>
         * 
         * @param reservedInstancesOfferingId
         *        The ID of the Reserved Instance offering to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferingId(String reservedInstancesOfferingId);

        /**
         * <p>
         * Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved
         * Instances are not purchased at unexpected prices.
         * </p>
         * 
         * @param limitPrice
         *        Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the
         *        Reserved Instances are not purchased at unexpected prices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitPrice(ReservedInstanceLimitPrice limitPrice);

        /**
         * <p>
         * Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved
         * Instances are not purchased at unexpected prices.
         * </p>
         * This is a convenience that creates an instance of the {@link ReservedInstanceLimitPrice.Builder} avoiding the
         * need to create one manually via {@link ReservedInstanceLimitPrice#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservedInstanceLimitPrice.Builder#build()} is called immediately
         * and its result is passed to {@link #limitPrice(ReservedInstanceLimitPrice)}.
         * 
         * @param limitPrice
         *        a consumer that will call methods on {@link ReservedInstanceLimitPrice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limitPrice(ReservedInstanceLimitPrice)
         */
        default Builder limitPrice(Consumer<ReservedInstanceLimitPrice.Builder> limitPrice) {
            return limitPrice(ReservedInstanceLimitPrice.builder().apply(limitPrice).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private Integer instanceCount;

        private String reservedInstancesOfferingId;

        private ReservedInstanceLimitPrice limitPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedInstancesOfferingRequest model) {
            instanceCount(model.instanceCount);
            reservedInstancesOfferingId(model.reservedInstancesOfferingId);
            limitPrice(model.limitPrice);
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getReservedInstancesOfferingId() {
            return reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        public final ReservedInstanceLimitPrice.Builder getLimitPrice() {
            return limitPrice != null ? limitPrice.toBuilder() : null;
        }

        @Override
        public final Builder limitPrice(ReservedInstanceLimitPrice limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public final void setLimitPrice(ReservedInstanceLimitPrice.BuilderImpl limitPrice) {
            this.limitPrice = limitPrice != null ? limitPrice.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedInstancesOfferingRequest build() {
            return new PurchaseReservedInstancesOfferingRequest(this);
        }
    }
}
