/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the state of a network interface permission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NetworkInterfacePermissionState implements
        ToCopyableBuilder<NetworkInterfacePermissionState.Builder, NetworkInterfacePermissionState> {
    private final String state;

    private final String statusMessage;

    private NetworkInterfacePermissionState(BuilderImpl builder) {
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The state of the permission.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link NetworkInterfacePermissionStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateString}.
     * </p>
     * 
     * @return The state of the permission.
     * @see NetworkInterfacePermissionStateCode
     */
    public NetworkInterfacePermissionStateCode state() {
        return NetworkInterfacePermissionStateCode.fromValue(state);
    }

    /**
     * <p>
     * The state of the permission.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link NetworkInterfacePermissionStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stateString}.
     * </p>
     * 
     * @return The state of the permission.
     * @see NetworkInterfacePermissionStateCode
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * A status message, if applicable.
     * </p>
     * 
     * @return A status message, if applicable.
     */
    public String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfacePermissionState)) {
            return false;
        }
        NetworkInterfacePermissionState other = (NetworkInterfacePermissionState) obj;
        return Objects.equals(stateString(), other.stateString()) && Objects.equals(statusMessage(), other.statusMessage());
    }

    @Override
    public String toString() {
        return ToString.builder("NetworkInterfacePermissionState").add("State", stateString())
                .add("StatusMessage", statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "StatusMessage":
            return Optional.of(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkInterfacePermissionState> {
        /**
         * <p>
         * The state of the permission.
         * </p>
         * 
         * @param state
         *        The state of the permission.
         * @see NetworkInterfacePermissionStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfacePermissionStateCode
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the permission.
         * </p>
         * 
         * @param state
         *        The state of the permission.
         * @see NetworkInterfacePermissionStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfacePermissionStateCode
         */
        Builder state(NetworkInterfacePermissionStateCode state);

        /**
         * <p>
         * A status message, if applicable.
         * </p>
         * 
         * @param statusMessage
         *        A status message, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfacePermissionState model) {
            state(model.state);
            statusMessage(model.statusMessage);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(NetworkInterfacePermissionStateCode state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public NetworkInterfacePermissionState build() {
            return new NetworkInterfacePermissionState(this);
        }
    }
}
