/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Internet gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InternetGateway implements ToCopyableBuilder<InternetGateway.Builder, InternetGateway> {
    private final List<InternetGatewayAttachment> attachments;

    private final String internetGatewayId;

    private final List<Tag> tags;

    private InternetGateway(BuilderImpl builder) {
        this.attachments = builder.attachments;
        this.internetGatewayId = builder.internetGatewayId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Any VPCs attached to the Internet gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any VPCs attached to the Internet gateway.
     */
    public List<InternetGatewayAttachment> attachments() {
        return attachments;
    }

    /**
     * <p>
     * The ID of the Internet gateway.
     * </p>
     * 
     * @return The ID of the Internet gateway.
     */
    public String internetGatewayId() {
        return internetGatewayId;
    }

    /**
     * <p>
     * Any tags assigned to the Internet gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the Internet gateway.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachments());
        hashCode = 31 * hashCode + Objects.hashCode(internetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternetGateway)) {
            return false;
        }
        InternetGateway other = (InternetGateway) obj;
        return Objects.equals(attachments(), other.attachments())
                && Objects.equals(internetGatewayId(), other.internetGatewayId()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("InternetGateway").add("Attachments", attachments())
                .add("InternetGatewayId", internetGatewayId()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachments":
            return Optional.of(clazz.cast(attachments()));
        case "InternetGatewayId":
            return Optional.of(clazz.cast(internetGatewayId()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InternetGateway> {
        /**
         * <p>
         * Any VPCs attached to the Internet gateway.
         * </p>
         * 
         * @param attachments
         *        Any VPCs attached to the Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<InternetGatewayAttachment> attachments);

        /**
         * <p>
         * Any VPCs attached to the Internet gateway.
         * </p>
         * 
         * @param attachments
         *        Any VPCs attached to the Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(InternetGatewayAttachment... attachments);

        /**
         * <p>
         * The ID of the Internet gateway.
         * </p>
         * 
         * @param internetGatewayId
         *        The ID of the Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGatewayId(String internetGatewayId);

        /**
         * <p>
         * Any tags assigned to the Internet gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the Internet gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    static final class BuilderImpl implements Builder {
        private List<InternetGatewayAttachment> attachments;

        private String internetGatewayId;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(InternetGateway model) {
            attachments(model.attachments);
            internetGatewayId(model.internetGatewayId);
            tags(model.tags);
        }

        public final Collection<InternetGatewayAttachment.Builder> getAttachments() {
            return attachments != null ? attachments.stream().map(InternetGatewayAttachment::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachments(Collection<InternetGatewayAttachment> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(InternetGatewayAttachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        public final void setAttachments(Collection<InternetGatewayAttachment.BuilderImpl> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copyFromBuilder(attachments);
        }

        public final String getInternetGatewayId() {
            return internetGatewayId;
        }

        @Override
        public final Builder internetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
            return this;
        }

        public final void setInternetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public InternetGateway build() {
            return new InternetGateway(this);
        }
    }
}
